package com.bxm.adsmanager.model.dto;

import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;

/**
 * @author tangx
 * @date 2020/10/9 14:41
 */
@Data
public class AdAssetsInspireVideoDto {

    private Long id;

    /**
     * 广告券ID
     */
    @NotNull
    private Long ticketId;

    /**
     * 视频方向(1.横版 2.竖版)
     */
    private Short videoDirection;

    /**
     * 视频
     */
    @NotBlank
    private String videoUrl;

    /**
     * 标题
     */
    @NotBlank
    private String title;

    /**
     * ICON
     */
    @NotBlank
    private String iconUrl;

    /**
     * 素材名称
     */
    @NotBlank
    private String assetsName;

    /**
     * 广告内容
     */
    @NotBlank
    private String content;

    /**
     * 按钮内容
     */
    @NotBlank
    private String buttonContent;

    /**
     * 视频尺寸长度
     */
    @NotNull
    private Integer videoHeight;

    /**
     * 视频尺寸宽度
     */
    @NotNull
    private Integer videoWidth;

    /**
     * 视频时长
     */
    @NotNull
    private Double videoDuration;

    /**
     * 封面图
     */
    @NotNull
    private String coverUrl;

    /**
     * 视频文件大小 单位byte
     */
    private Long videoFileSize;

    private String createUser;

    private String modifyUser;

}
