package com.bxm.adsmanager.model.dto;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 具体素材配置<br/>
 *
 * @author kerry.jiang
 * @date 2021/6/22 9:57
 */
@Data
public class AdAssetsTemplateAssetsJsonConfig {

    /**
     * 模板id
     */
    private String templateId;

    /**
     * 模板名称
     */
    private String templateName;

    /**
     * 广告标题
     */
    private String title;

    /**
     * 广告内容
     */
    private String content;

    /**
     * APP名称/广告来源
     */
    private String originName;

    /**
     * 按钮内容
     */
    private String buttonText;

    /**
     * 广告Icon
     */
    private String icon;

    /**
     * 图片
     */
    private String image;

    /**
     * 封面/结束图
     */
    private String coverOrEndImage;

    /**
     * Banner图
     */
    private String bannerImage;

    /**
     * 视频内容
     */
    private String video;

    /**
     * 视频时长/s
     */
    private String videoDuration;

    /**
     * 视频码率
     */
    private String videoKbps;

    /**
     * 视频大小/Byte
     */
    private String videoSize;

    /**
     * 动画弹窗id
     */
    private String popupStyleId;

    /**
     * 动画弹窗素材
     * [{sort: 1, description: "背景大图", configType: 1, imgUrl: "https://m.cudaojia.com/dist/ACTIVITY/certificate/2021/05/26/b22373ae-a8a2-4b86-b6ae-6d8fdcd8758b"}
     * , {sort: 2, description: "底部文案", configType: 2, textContent: "wefwef"}]
     */
    private String popupConfigs;
}
