package com.bxm.adsmanager.model.dto;

import java.io.Serializable;
import java.util.List;

import org.hibernate.validator.constraints.NotBlank;

import com.bxm.adsmanager.model.dao.adkeeper.AdAssets;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsTemplateContent;

import lombok.Data;

/**
 * 素材模板.</br>
 * Created by zhengwangeng on 2021/6/15
 */
@Data
public class AdAssetsTemplateDTO implements Serializable {

	private static final long serialVersionUID = 8255898196234336477L;

    /**
     * 名称
     */
    @NotBlank(message = "名称不能为空")
    private String name;

    /**
     * 快手素材模板类型：横图、竖图等。可能为空，为空的话表示未知。
     */
    private Integer type;

    /**
     * SDK模板类型
     * @see com.bxm.adsmanager.model.enums.AssetsTemplateSdkTemplateTypeEnum
     */
    private Integer sdkTemplateType;

    /**
     * 模版示例图
     */
    //@NotBlank(message = "模版示例图不能为空")
    private String demoPicture;

    /**
     * 扩展信息
     */
    private String ext;

    /**
     * 是否系统创建
     */
    private Short systemCreate = 0;

    /**
     * 素材模板内容
     */
    private List<AdAssetsTemplateContent> adAssetsTemplateContents;

    private String createUser;
}