package com.bxm.adsmanager.model.dto;

import java.util.Date;

import org.hibernate.validator.constraints.NotBlank;

import com.bxm.adsmanager.model.base.BaseDto;

/**
 * <h3>流量包</h3>
 * 
 * @author 拉拉
 * @since V1.0.0, 2017/12/07 18:55
 */
public class AdFlowPackageDto extends BaseDto {

    @NotBlank(message = "媒体入口不能为空", groups = { AdFlowPackageDto.Add.class, AdFlowPackageDto.Update.class })
    private String  positionId; // 媒体入口
    @NotBlank(message = "流量包名称不能为空", groups = { AdFlowPackageDto.Add.class, AdFlowPackageDto.Update.class })
    private String  packageName;// 流量包名称

    private Integer count;      // 选中数量

    private Integer type;       // 类型

    @NotBlank(message = "是否共享不能为空", groups = { AdFlowPackageDto.Add.class, AdFlowPackageDto.Update.class })
    private String  isShare;    // 是否共享（y是，n不是）

    @NotBlank(message = "状态不能为空", groups = { AdFlowPackageDto.Add.class, AdFlowPackageDto.Update.class })
    private String  state;      // 状态（y启用，n禁用）

    private String  remark;

    private String  modifyUser;

    private Date    modifyTime;

    public Integer getMark() {
        return mark;
    }

    public void setMark(Integer mark) {
        this.mark = mark;
    }

    private Integer mark;


    /**
     * @return the modifyTime
     */
    public Date getModifyTime() {
        return modifyTime;
    }

    /**
     * @param modifyTime the modifyTime to set
     */
    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    /**
     * @return the modifyUser
     */
    public String getModifyUser() {
        return modifyUser;
    }

    /**
     * @param modifyUser the modifyUser to set
     */
    public void setModifyUser(String modifyUser) {
        this.modifyUser = modifyUser;
    }

    /**
     * @return the remark
     */
    public String getRemark() {
        return remark;
    }

    /**
     * @return the type
     */
    public Integer getType() {
        return type;
    }

    /**
     * @param type the type to set
     */
    public void setType(Integer type) {
        this.type = type;
    }

    /**
     * @param remark the remark to set
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    /**
     * @return the positionId
     */
    public String getPositionId() {
        return positionId;
    }

    /**
     * @param positionId the positionId to set
     */
    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    /**
     * @return the packageName
     */
    public String getPackageName() {
        return packageName;
    }

    /**
     * @param packageName the packageName to set
     */
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    /**
     * @return the count
     */
    public Integer getCount() {
        return count;
    }

    /**
     * @param count the count to set
     */
    public void setCount(Integer count) {
        this.count = count;
    }

    /**
     * @return the isShare
     */
    public String getIsShare() {
        return isShare;
    }

    /**
     * @param isShare the isShare to set
     */
    public void setIsShare(String isShare) {
        this.isShare = isShare;
    }

    /**
     * @return the state
     */
    public String getState() {
        return state;
    }

    /**
     * @param state the state to set
     */
    public void setState(String state) {
        this.state = state;
    }

    public interface Add {
    }

    public interface Update {
    }
}
