package com.bxm.adsmanager.model.dto;

import javax.validation.constraints.NotNull;

import com.bxm.adsmanager.model.base.BaseDto;

public class AdPositionAssetSizeDto extends BaseDto {

    @NotNull(message = "广告位类型不能为空", groups = { AdPositionAssetSizeDto.Add.class, AdPositionAssetSizeDto.Update.class })
    private Short   type;              // 广告位类型。0- 浮标位、1- 展示位

    @NotNull(message = "尺寸比例长不能为空", groups = { AdPositionAssetSizeDto.Add.class, AdPositionAssetSizeDto.Update.class })
    private Short    scaleLength;        // 尺寸比例长
    @NotNull(message = "尺寸比例宽不能为空", groups = { AdPositionAssetSizeDto.Add.class, AdPositionAssetSizeDto.Update.class })
    private Short    scaleWidth;        // 尺寸比例宽

    @NotNull(message = "最小尺寸长不能为空", groups = { AdPositionAssetSizeDto.Add.class, AdPositionAssetSizeDto.Update.class })
    private Integer    minLength;        // 最小尺寸长
    @NotNull(message = "最小尺寸宽不能为空", groups = { AdPositionAssetSizeDto.Add.class, AdPositionAssetSizeDto.Update.class })
    private Integer    minWidth;        // 最小尺寸宽

    @NotNull(message = "最大尺寸长不能为空", groups = { AdPositionAssetSizeDto.Add.class, AdPositionAssetSizeDto.Update.class })
    private Integer    maxLength;        // 最大尺寸长
    @NotNull(message = "最大尺寸宽不能为空", groups = { AdPositionAssetSizeDto.Add.class, AdPositionAssetSizeDto.Update.class })
    private Integer    maxWidth;        // 最大尺寸宽

    @NotNull(message = "状态不能为空", groups = { AdPositionAssetSizeDto.Add.class, AdPositionAssetSizeDto.Update.class })
    private Short    status;        // 状态。0- 停用、1- 启用

    public Short getType() {
        return type;
    }

    public void setType(Short type) {
        this.type = type;
    }

    public Short getScaleLength() {
        return scaleLength;
    }

    public void setScaleLength(Short scaleLength) {
        this.scaleLength = scaleLength;
    }

    public Short getScaleWidth() {
        return scaleWidth;
    }

    public void setScaleWidth(Short scaleWidth) {
        this.scaleWidth = scaleWidth;
    }

    public Integer getMinLength() {
        return minLength;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    public Integer getMinWidth() {
        return minWidth;
    }

    public void setMinWidth(Integer minWidth) {
        this.minWidth = minWidth;
    }

    public Integer getMaxLength() {
        return maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public Integer getMaxWidth() {
        return maxWidth;
    }

    public void setMaxWidth(Integer maxWidth) {
        this.maxWidth = maxWidth;
    }

    public Short getStatus() {
        return status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    public interface Add {
    }

    public interface Update {
    }

}
