package com.bxm.adsmanager.model.dto;
/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */


import java.io.Serializable;

import com.bxm.adsmanager.model.base.BaseDto;

/**
 * <h3></h3>
 * @author hcmony
 * @since V1.0.0, 2017/12/12 15:06
 */
public class AdPositionSearchDto extends BaseDto implements Serializable{

    private static final long serialVersionUID = -5354441247118392470L;
    /**
     * 媒体名称
     */
    private String mediaName;

    /**
     * 券id
     */
    private Long adTicketId;

    /**
     * 广告位id 集合;
     */
    private String idsStr;

    /**
     * 媒体类型code
     */
    private String mediaType;

    /**
     * 媒体分类ID
     */
    private String mediaClassId;

    /**
     * 媒体子分类ID
     */
    private String mediaChildClassId;

    /**
     * 券码投放?0:关闭，1:开启 ？true开启， false 关闭
     */
    private Byte couponsPutinFlag;

    /**
     * 投放方式类型：1常规投放，2券码类投放，3激励视频投放
     */
    private Byte putinType;

    /**
     * 广告位ADX类型
     * @see com.bxm.adsmedia.model.enums.AppEntranceAdxAdTypeEnum
     */
    private Short adType;

    /**
     * 广告位场景类型
     * @see com.bxm.adsmedia.model.enums.AppEntranceAdxPositionTypeEnum
     */
    private Short positionType;

    /**
     * 广告位名称
     *
     * @return
     */
    private String entranceName;

    private Byte positionScene;

    /**
     * 广告券类型
     * 不同广告券需要的广告位不一样
     * 活动券中的广告位仅为ADX支持互动广告的广告位（老的ADX广告位不出现在活动广告）
     * 常规券中的广告位仅为现有互动的广告位+ADX支持互动广告的广告位
     * 直投券中的广告位仅为ADX支持直投广告的广告位（老的ADX广告位不出现在直投广告）
     */
    private Integer ticketType;

    /**
     * 对接方式：0获取链接,1JS对接,2API对接,3SDK对接，默认0
     */
    private Byte dockingMethod;

    /**
     * 所属国家
     */
    private String country;


    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getIdsStr() {
		return idsStr;
	}

	public void setIdsStr(String idsStr) {
		this.idsStr = idsStr;
	}

	public Long getAdTicketId() {
		return adTicketId;
	}

	public void setAdTicketId(Long adTicketId) {
		this.adTicketId = adTicketId;
	}

	public String getMediaName() {
		return mediaName;
	}

	public void setMediaName(String mediaName) {
		this.mediaName = mediaName;
	}

    public String getMediaType() {
        return mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public String getMediaClassId() {
        return mediaClassId;
    }

    public void setMediaClassId(String mediaClassId) {
        this.mediaClassId = mediaClassId;
    }

    public String getMediaChildClassId() {
        return mediaChildClassId;
    }

    public void setMediaChildClassId(String mediaChildClassId) {
        this.mediaChildClassId = mediaChildClassId;
    }

    public Byte getCouponsPutinFlag() {
        return couponsPutinFlag;
    }

    public void setCouponsPutinFlag(Byte couponsPutinFlag) {
        this.couponsPutinFlag = couponsPutinFlag;
    }

    public Byte getPutinType() {
        return putinType;
    }

    public void setPutinType(Byte putinType) {
        this.putinType = putinType;
    }

    public Short getAdType() {
        return adType;
    }

    public void setAdType(Short adType) {
        this.adType = adType;
    }

    public Short getPositionType() {
        return positionType;
    }

    public void setPositionType(Short positionType) {
        this.positionType = positionType;
    }

    public String getEntranceName() {
        return entranceName;
    }

    public void setEntranceName(String entranceName) {
        this.entranceName = entranceName;
    }

    public Byte getPositionScene() {
        return positionScene;
    }

    public void setPositionScene(Byte positionScene) {
        this.positionScene = positionScene;
    }

    public Integer getTicketType() {
        return ticketType;
    }

    public void setTicketType(Integer ticketType) {
        this.ticketType = ticketType;
    }

    public Byte getDockingMethod() {
        return dockingMethod;
    }

    public void setDockingMethod(Byte dockingMethod) {
        this.dockingMethod = dockingMethod;
    }
}
