package com.bxm.adsmanager.model.dto;

import java.util.List;
import java.util.Objects;

import com.bxm.adsmanager.model.constant.CommonConstant;
import org.apache.commons.lang3.StringUtils;

/**
 * @author tangx
 * @date 2020/6/22 15:15
 */
public class AdTicketAuditSearchDTO {

    private Integer pageNum = 1;

    private Integer pageSize = 20;

    /**
     * 券素材类型  1.互动广告 2.激励视频 3.素材模板素材（活动券或者直投券）
     * 这里字段取名有点歧义
     */
    private Integer ticketType = CommonConstant.AssetType.TICKET_TYPE_INTERACTIVE;

    /**
     * 券类型
     */
    private Integer type ;

    /**
     * 广告主Id或名称
     */
    private String advertiser;

    /**
     * 广告Id或名称
     */
    private String ticket;

    /**
     * 操作 (0.新增 1.编辑)
     */
    private Integer operate;

    /**
     * 广告状态：0-待审核，1-审核通过，2-审核拒绝
     */
    private Integer ticketStatus;

    /**
     * 广告主状态
     */
    private Byte advertiserStatus;

    /**
     * 广告主:素材审核白名单状态 （0.非白名单 1.白名单）
     */
    private Byte assetAuditWhiteStatus;

    /**
     * 判断是否使用广告主id集合
     */
    private String queryFlag;

    /**
     * 广告主id集合
     */
    private List<Integer> advertiserIds;

    /**
     * 开始时间
     */
    private String startTime;

    /**
     * 结束时间
     */
    private String endTime;

    /**
     * 备注
     */
    private String remark;

    private Integer tagCode;

    /**
     * ticketId List 非前端传入
     */
    private List<Long> ticketIdList;

    /**
     * 素材名称或者id关键字
     */
    private String assetsKeywords;

    private String assetsStatus;

    /**
     * 检查状态：1已检查，2未检查
     */
    private String checkStatus;

    /**
     * 是否广告主资质待审核  0.否 1.是
     */
    private Integer qualifyWarningFlag;

    /**
     * 排除广告主id集合
     */
    private List<Integer> excludeAdvertiserIds;

    /**
     * 地区类型：0.国内 1.海外
     */
    private Integer areaType;

    public List<Integer> getExcludeAdvertiserIds() {
        return excludeAdvertiserIds;
    }

    public void setExcludeAdvertiserIds(List<Integer> excludeAdvertiserIds) {
        this.excludeAdvertiserIds = excludeAdvertiserIds;
    }

    public Integer getQualifyWarningFlag() {
        return qualifyWarningFlag;
    }

    public void setQualifyWarningFlag(Integer qualifyWarningFlag) {
        this.qualifyWarningFlag = qualifyWarningFlag;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getAdvertiser() {
        return advertiser;
    }

    public void setAdvertiser(String advertiser) {
        this.advertiser = advertiser;
    }

    public String getTicket() {
        return ticket;
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }

    public Integer getOperate() {
        return operate;
    }

    public String getAssetsKeywords() {
        return assetsKeywords;
    }

    public void setAssetsKeywords(String assetsKeywords) {
        this.assetsKeywords = assetsKeywords;
    }

    public void setOperate(Integer operate) {
        this.operate = operate;
    }

    public Integer getTicketStatus() {
        return ticketStatus;
    }

    public void setTicketStatus(Integer ticketStatus) {
        this.ticketStatus = ticketStatus;
    }

    public Byte getAdvertiserStatus() {
        return advertiserStatus;
    }

    public void setAdvertiserStatus(Byte advertiserStatus) {
        this.advertiserStatus = advertiserStatus;
    }

    public Byte getAssetAuditWhiteStatus() {
        return assetAuditWhiteStatus;
    }

    public void setAssetAuditWhiteStatus(Byte assetAuditWhiteStatus) {
        this.assetAuditWhiteStatus = assetAuditWhiteStatus;
    }

    public String getQueryFlag() {
        return queryFlag;
    }

    public void setQueryFlag(String queryFlag) {
        this.queryFlag = queryFlag;
    }

    public List<Integer> getAdvertiserIds() {
        return advertiserIds;
    }

    public void setAdvertiserIds(List<Integer> advertiserIds) {
        this.advertiserIds = advertiserIds;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public List<Long> getTicketIdList() {
        return ticketIdList;
    }

    public void setTicketIdList(List<Long> ticketIdList) {
        this.ticketIdList = ticketIdList;
    }

    public Integer getTagCode() {
        return tagCode;
    }

    public void setTagCode(Integer tagCode) {
        this.tagCode = tagCode;
    }

    public String getAssetsStatus() {
        return assetsStatus;
    }

    public void setAssetsStatus(String assetsStatus) {
        this.assetsStatus = assetsStatus;
    }

    public Integer getTicketType() {
        return ticketType;
    }

    public void setTicketType(Integer ticketType) {
        this.ticketType = ticketType;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(String checkStatus) {
        this.checkStatus = checkStatus;
    }

    public Integer getAreaType() {
        return areaType;
    }

    public void setAreaType(Integer areaType) {
        this.areaType = areaType;
    }

    /**
     * 是否存在搜索广告主相关的条件
     * @return
     */
    public boolean isQueryAdvertiser() {
        return StringUtils.isNotBlank(advertiser)
                || Objects.nonNull(advertiserStatus)
                || Objects.nonNull(assetAuditWhiteStatus)
                || Objects.nonNull(areaType);
    }
}
