package com.bxm.adsmanager.model.dto;
/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

import java.util.Date;

import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;

import org.hibernate.validator.constraints.NotBlank;
import org.springframework.format.annotation.DateTimeFormat;

import com.bxm.adsmanager.model.base.BaseDto;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketOcpcConf;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketPersonsGradeConf;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.commons.currency.Money;
import com.bxm.util.StringUtil;
import com.bxm.warcar.utils.localdate.LocalDateTimeHelper;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;

/**
 * <h3>广告券的前端参数模版类</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2017/12/07 18:55
 */
public class AdTicketDto extends BaseDto {

    @NotBlank(message = "name不能为空", groups = { AdTicketDto.Add.class, AdTicketDto.Update.class })
    private String  name;              // name

    @NotNull(message = "广告主id不能为空", groups = { AdTicketDto.Add.class, AdTicketDto.Update.class })
    private Long    advertiser;        // 广告主id // 调广告主接口

    @NotNull(message = "结算类型不能为空", groups = { AdTicketDto.Add.class, AdTicketDto.Update.class })
    private Short   settleType;        // 结算方式：1- CPC、2- CPA、4- CPM

    @NotNull(message = "单价不能为空", groups = { AdTicketDto.Add.class, AdTicketDto.Update.class })
    @DecimalMin(value = "0.001", message = "出价必须大于0.001", groups = { AdTicketDto.Add.class, AdTicketDto.Update.class })
    private Double  price;             // 单价

    @NotNull(message = "广告券类型不能为空", groups = { AdTicketDto.Add.class, AdTicketDto.Update.class })
    private Short   type;              // 广告券类型。

    private  Short aim;   //投放目标 （1拉新  2 拉活）

    @NotNull(message = "日限额（预算）不能为空", groups = { AdTicketDto.Add.class, AdTicketDto.Update.class })
    private Double  budgetDaily;       // 日限额（预算），CPC单位是元，CPA单位是张。0 表示无限额。如果是金额，单位：厘

    @NotNull(message = "投放模式不能为空", groups = { AdTicketDto.Add.class, AdTicketDto.Update.class })
    private Integer consumeModal = Ticket.CONSUME_MODAL_FAST;

    @NotBlank(message = "所属行业广告分类不能为空", groups = { AdTicketDto.Add.class, AdTicketDto.Update.class })
    private String  domainCode;        // 所属行业 广告分类 // tbl_ad_domain 调接口 数据采集

    @NotNull(message = "独立成本不能为空", groups = { AdTicketDto.Add.class, AdTicketDto.Update.class })
    private Double  standaloneCost;    // 独立成本。百分比

    @NotBlank(message = "落地页不能为空", groups = { AdTicketDto.Add.class, AdTicketDto.Update.class })
    private String  url;               // 落地页

    @NotNull(message = "有效期开始不能为空", groups = { AdTicketDto.Add.class, AdTicketDto.Update.class })
    @DateTimeFormat(pattern = LocalDateTimeHelper.PATTERN_STR10)
    private Date    validStartDate;    // 有效期开始

    @NotNull(message = "有效期结束不能为空", groups = { AdTicketDto.Add.class, AdTicketDto.Update.class })
    @DateTimeFormat(pattern = LocalDateTimeHelper.PATTERN_STR10)
    private Date    validEndDate;      // 有效期结束

    //@NotNull(message = "是否支持微信不能为空", groups = { AdTicketDto.Add.class, AdTicketDto.Update.class })
    @Deprecated
    private Short   isSupportWechat;   // 是否支持微信。0- 不支持、1- 支持

    /**
     * 投放平台  其他 = 0,微信 = 1, 支付宝 = 2
     * @see com.bxm.adsprod.facade.ticket.App
     */
    private String apps;

    private Integer userGradePassScore;// 用户评分及格分数线

    @NotNull(message = "状态不能为空", groups = { AdTicketDto.Add.class })
    private Short   status;            // 状态。2- 暂停、1- 正常、3 关闭、99 已删除

    private Integer pauseReason;       // 暂停原因。1- 超出预算、2- 余额不足

    private short isEffectMonitor;     //是否接入效果监控; 1-否 2-接入且精确  3-接入但不准

    private short lastStatus;//记录状态修改前的正的状态

    private Double oldPrice;// 旧的修改单价

    private String createUser;// 创建人
    @DateTimeFormat(pattern = LocalDateTimeHelper.PATTERN_STR19)
    private Date modifyTime;//修改时间

    /**
     * 广告组ID
     */
    private Boolean isGroup;
    private Long groupId;


    // 权重
    private Double                   weight;          // tbl_ad_ticket_weight_manual_conf 1对1

    // 广告素材 调素材添加接口，返回广告券素材列表 传广告素材表id tbl_ad_assets 存入关联表中tbl_ad_ticket_assets_ref
    private String                   assetsids;

    // 广告标签 tbl_ad_tag 调接口 数据采集
    private String                   tags;               // 1对多 tbl_ad_rules 1-1-100

    // 区域定向 city=城市 缺城市表，然后写接口调城市列表 调 张凯接口 tbl_ad_rules
    private String                   citys;           // 1对多 tbl_ad_rules 110000,522501
    private Boolean booleanCitys;

    //区域定向  ipLib=指定ip库
    private String ipLibrary;

    // 操作平台 数组 json 格式
    private String                   oss;             // 1对多 tbl_ad_ticket_os_conf

    // 人群定向 要调个推接口匹配数据 json 格式
    private AdTicketPersonsGradeConf ref;             // tbl_ad_ticket_persons_grade_conf 1对1

    private String                   personsGradeConf;

    // 投放控制
    private ControlDto               controlDto;

    // OCPC
    private OcpcConfDto              ocpcConf;

    /**
     * 流量包ID 为黑白名单而生
     */
    private String flowPackageIdArray;

    /**
     * 流量包信息为限额出价而生
     */
    private String flowPackageArray;

    /**
     * 流量包限额出价配置项列表
     */
    private String flowPackageArrayConfs;
    /**
     * 广告位出价限额配置列表
     */
    private String positionTimesLimitConfig;

    // 广告票券码素材不能为空,至少添加一套展示位，浮标位素材
    private String                   assetscouponsids;
    private CouponsInfoDto  couponsInfoDto; //票券码类配置信息

    private String                   assetsadxids;// ADX素材
    private AdxConfDto adxConfDto; //ADX互动/ADX直投 配置信息

    private InspireVideoConfDto      inspireVideoConfDto; //激励视频 配置信息

    private TicketAppExtendDto ticketAppExtendDto;  // app相关配置

    /**
     * 我方广告主所属一级行业ID(美团使用)
     */
    private Integer primaryIndustryId;

    /**
     * 我方广告主所属二级行业ID（美团使用）
     */
    private Integer secondaryIndustryId;

    // 是否进行美团审核
    private Integer isMeituanReview;

    /**
     * 广告位场景定向(逗号分开)：1.互动广告 2.自渲染 4.开屏 5.信息流大图
     */
    private String positionSceneConfig;

    /**
     * 流量控制备用配置
     */
    private String trafficControlBakConfig;

    /**
     * 权益奖励ID
     */
    private Long rightsId;

    /**
     * 域名组ID
     */
    private String kylinGroupId;

    /**
     * 效果监控转化目标（OCPA必传）
     */
    private Short targetConvType;

    /**
     *  rtb对应的开发者
     */
    private String rtbAppKey;

    /**
     * 追价预算余额
     */
    private Double chasePriceBalance;

    /**
     * 追价CPC出价
     */
    private Double chasePriceCpcPrice;

    /**
     * 追价CPC出价配置的广告主id，多个用逗号分开
     */
    private String chasePriceCpcPositionId;

    /**
     * 广告位追价配置
     * [{"positionId":"001811-10", "balance":800, "price":80}]
     */
    private String chasePriceConfig;

    /**
     * 是否是重新提交审核（只在券状态为【审核拒绝】情况下使用有效）
     */
    private Boolean resubmitReview;

    /**
     * 广告&活动标签 用于直投集合页活动
     */
    private Integer ticketActivityMatchTag;

    /**
     * 是否去重有效点击 0.是 1.否
     */
    private Byte deduplicateValidClick;


    /**
     * 算法优化目标（1单目标优化 2 双目标优化）
     */
    private Short algoTarget;


    public String getChasePriceConfig() {
        return chasePriceConfig;
    }

    public void setChasePriceConfig(String chasePriceConfig) {
        this.chasePriceConfig = chasePriceConfig;
    }

    public Short getAlgoTarget() {
        return algoTarget;
    }

    public void setAlgoTarget(Short algoTarget) {
        this.algoTarget = algoTarget;
    }

    public String getChasePriceCpcPositionId() {
        return chasePriceCpcPositionId;
    }

    public void setChasePriceCpcPositionId(String chasePriceCpcPositionId) {
        this.chasePriceCpcPositionId = chasePriceCpcPositionId;
    }

    public Byte getDeduplicateValidClick() {
        return deduplicateValidClick;
    }

    public void setDeduplicateValidClick(Byte deduplicateValidClick) {
        this.deduplicateValidClick = deduplicateValidClick;
    }

    public Integer getTicketActivityMatchTag() {
        return ticketActivityMatchTag;
    }

    public void setTicketActivityMatchTag(Integer ticketActivityMatchTag) {
        this.ticketActivityMatchTag = ticketActivityMatchTag;
    }

    public Boolean getResubmitReview() {
        return resubmitReview == null ? false : resubmitReview;
    }

    public void setResubmitReview(Boolean resubmitReview) {
        this.resubmitReview = resubmitReview;
    }

    public Double getChasePriceBalance() {
        return chasePriceBalance;
    }

    public void setChasePriceBalance(Double chasePriceBalance) {
        this.chasePriceBalance = chasePriceBalance;
    }

    public Double getChasePriceCpcPrice() {
        return chasePriceCpcPrice;
    }

    public void setChasePriceCpcPrice(Double chasePriceCpcPrice) {
        this.chasePriceCpcPrice = chasePriceCpcPrice;
    }

    public Short getTargetConvType() {
        return targetConvType;
    }

    public void setTargetConvType(Short targetConvType) {
        this.targetConvType = targetConvType;
    }

    public String getRtbAppKey() {
        return rtbAppKey;
    }

    public void setRtbAppKey(String rtbAppKey) {
        this.rtbAppKey = rtbAppKey;
    }

    public String getKylinGroupId() {
        return kylinGroupId;
    }

    public void setKylinGroupId(String kylinGroupId) {
        this.kylinGroupId = kylinGroupId;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public short getIsEffectMonitor() {
        return isEffectMonitor;
    }

    public void setIsEffectMonitor(short isEffectMonitor) {
        this.isEffectMonitor = isEffectMonitor;
    }

    public short getLastStatus() {
        return lastStatus;
    }

    public void setLastStatus(short lastStatus) {
        this.lastStatus = lastStatus;
    }

    public Double getOldPrice() {
        return oldPrice;
    }

    public void setOldPrice(Double oldPrice) {
        this.oldPrice = oldPrice;
    }

    public Short getAim() {
        return aim;
    }

    public void setAim(Short aim) {
        this.aim = aim;
    }

    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public Boolean getIsGroup() {
        return isGroup==null?false:isGroup;
    }

    public void setIsGroup(Boolean isGroup) {
        this.isGroup = isGroup;
    }

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public String getIpLibrary() {
        return ipLibrary;
    }

    public void setIpLibrary(String ipLibrary) {
        this.ipLibrary = ipLibrary;
    }

    public String getAssetscouponsids() {
        return assetscouponsids;
    }

    public void setAssetscouponsids(String assetscouponsids) {
        this.assetscouponsids = assetscouponsids;
    }

    public CouponsInfoDto getCouponsInfoDto() {
        return couponsInfoDto;
    }

    public void setCouponsInfoDto(CouponsInfoDto couponsInfoDto) {
        this.couponsInfoDto = couponsInfoDto;
    }

    public String getFlowPackageIdArray() {
        return flowPackageIdArray;
    }

    public void setFlowPackageIdArray(String flowPackageIdArray) {
        this.flowPackageIdArray = flowPackageIdArray;
    }

    public String getFlowPackageArray() {
        return flowPackageArray;
    }

    public void setFlowPackageArray(String flowPackageArray) {
        this.flowPackageArray = flowPackageArray;
    }

    public String getFlowPackageArrayConfs() {
        return flowPackageArrayConfs;
    }

    public void setFlowPackageArrayConfs(String flowPackageArrayConfs) {
        this.flowPackageArrayConfs = flowPackageArrayConfs;
    }

    public String getPositionTimesLimitConfig() {
        return positionTimesLimitConfig;
    }

    public void setPositionTimesLimitConfig(String positionTimesLimitConfig) {
        this.positionTimesLimitConfig = positionTimesLimitConfig;
    }

    public String getPositionSceneConfig() {
        return positionSceneConfig;
    }

    public void setPositionSceneConfig(String positionSceneConfig) {
        this.positionSceneConfig = positionSceneConfig;
    }

    public String getTrafficControlBakConfig() {
        return trafficControlBakConfig;
    }

    public void setTrafficControlBakConfig(String trafficControlBakConfig) {
        this.trafficControlBakConfig = trafficControlBakConfig;
    }

    public Long getRightsId() {
        return rightsId;
    }

    public void setRightsId(Long rightsId) {
        this.rightsId = rightsId;
    }

    public static class OcpcConfDto {
        private Long    ticketId;
        private Short   isSupportOcpc;
        private Double  cpaExpectPrice;
        //追价cpa
        private Double  chaseCpaPrice;
        private Integer closeThreshold;
        //新增字段 旧的预期cpa-日志记录用
        private Double  oldCpaPrice;
        // 深层目标cpa
        private Double cpaDeepExpectPrice;
        private Integer deepExpectActionType;
        private Integer expectActionType;

        public AdTicketOcpcConf to() {
            AdTicketOcpcConf dest = new AdTicketOcpcConf();
            dest.setCloseThreshold(getCloseThreshold());
            dest.setIsSupportOcpc(getIsSupportOcpc());
            dest.setTicketId(getTicketId());
            Double cpaExpectPrice = getCpaExpectPrice();
            if (null != cpaExpectPrice) {
                dest.setCpaExpectPrice(Long.valueOf(Money.ofYuan(cpaExpectPrice).getLi()).intValue());
            }
            if (null != chaseCpaPrice) {
                dest.setChaseCpaPrice(Long.valueOf(Money.ofYuan(chaseCpaPrice).getLi()).intValue());
            }
            if (null != cpaDeepExpectPrice) {
                dest.setCpaDeepExpectPrice(Long.valueOf(Money.ofYuan(cpaDeepExpectPrice).getLi()).intValue());
            }
            dest.setDeepExpectActionType(getDeepExpectActionType());
            dest.setExpectActionType(getExpectActionType());
            return dest;
        }

        public Long getTicketId() {
            return ticketId;
        }

        public void setTicketId(Long ticketId) {
            this.ticketId = ticketId;
        }

        public Short getIsSupportOcpc() {
            return isSupportOcpc;
        }

        public void setIsSupportOcpc(Short isSupportOcpc) {
            this.isSupportOcpc = isSupportOcpc;
        }

        public Double getCpaExpectPrice() {
            return cpaExpectPrice;
        }

        public void setCpaExpectPrice(Double cpaExpectPrice) {
            this.cpaExpectPrice = cpaExpectPrice;
        }

        public Integer getCloseThreshold() {
            return closeThreshold;
        }

        public void setCloseThreshold(Integer closeThreshold) {
            this.closeThreshold = closeThreshold;
        }

        public Double getOldCpaPrice() {
            return oldCpaPrice;
        }

        public void setOldCpaPrice(Double oldCpaPrice) {
            this.oldCpaPrice = oldCpaPrice;
        }

        public Double getCpaDeepExpectPrice() {
            return cpaDeepExpectPrice;
        }

        public void setCpaDeepExpectPrice(Double cpaDeepExpectPrice) {
            this.cpaDeepExpectPrice = cpaDeepExpectPrice;
        }

        public Integer getDeepExpectActionType() {
            return deepExpectActionType;
        }

        public void setDeepExpectActionType(Integer deepExpectActionType) {
            this.deepExpectActionType = deepExpectActionType;
        }

        public Integer getExpectActionType() {
            return expectActionType;
        }

        public void setExpectActionType(Integer expectActionType) {
            this.expectActionType = expectActionType;
        }

        public Double getChaseCpaPrice() {
            return chaseCpaPrice;
        }

        public void setChaseCpaPrice(Double chaseCpaPrice) {
            this.chaseCpaPrice = chaseCpaPrice;
        }
    }

    public static class ControlDto {

        /**
         * 投放时段预算 {start}-{end}-{limit} start=开始时间。单位：小时 end=结束时间。单位：小时 limit=限额。金额或张，
         * 金额单位：前端传递为元，后端保存为厘
         * 1对多 tbl_ad_rules
         */
        private String times;
        private Boolean booleanTimes;

        /**
         * 投放时段出价 {start}-{end}-{limit}-{price}
         * 金额单位：前端传递为元，后端保存为厘
         * 1对多 tbl_ad_rules
         */
        private String timeBidding;

        /**
         * 广告位定向 先调用查询所有的广告位接口，传参数type=类型。1- 白名单、2- 黑名单position=广告位ID
         * 示例:：1-370f9c19101b46569c984cc5b6b4f1ee-1,f1863b20bee74412a1a075eaa65a15cd-1,fbca14bb5bb74d5a9b5fa165ad78a15a-6
         * 第一个的格式是：黑白名单-广告位ID
         * 第二个及以后的是格式是：广告位ID
         * 1对多 tbl_ad_rules
         */
        private String banners;

        /**
         * 未获取到用户imei 是否投放
         * tbl_ad_ticket_onoff
         */
        private String noimei;

        /**
         * 个推imei未匹配是否投放
         *  tbl_ad_ticket_onoff
         */
        private String imeinomatching;

        /**
         * 人群定向-人群设置，个推人群标签
         */
        private String personsGrade;

        /**
         * 频次控制规则 可以不填
         * @see com.bxm.adsmanager.model.enums.RuleTypeEnum.PINCI
         * tbl_ad_rules 1对1
         */
        private String frequencys;

        /**
         * 人群包定向
         * 1对多 tbl_ad_rules
         */
        private String crowdPackage;

        /**
         * adx券出券券包
         * 1对多 tbl_ad_rules
         */
        private String ticketPackage;

        /**
         * app包名定向
         */
        private String appPackageRule;

        /**
         * ADX App ID 定向
         */
        private String adxAppIdRule;

        /**
         * ISP运营商
         * 格式是：运营商1，运营商2
         * 1对多 tbl_ad_rules
         */
        private String isp;

        /**
         * 网络类型
         * 格式是：3g，4g
         * 1对多 tbl_ad_rules
         */
        private String networkType;
        /**
         * 广告位质量
         * 格式是：1优质，2终端
         * 1对多 tbl_ad_rules
         */
        private String adQuality;
        /**
         * 活动定向
         * 格式是：活动id，活动id
         * 1对多 tbl_ad_rules
         */
        private String activityOrientation;

        /**
         * 新老用户定向
         */
        private String newAndOldUsers;

        /**
         * 性别定向
         */
        private String getuiSex;

        /**
         * 百度性别定向
         */
        private String besGender;

        /**
         * 百度年龄定向
         */
        private String besAge;

        /**
         * 手机品牌
         */
        private String phoneBrand;

        /**
         * ADX App 入口流量定向
         * 1- 白名单、2- 黑名单  ticketId=活动券ID
         */
        private String adxAPPEntranceRule;

        /**
         * AppID包定向
         */
        private String appIdPackage;

        /**
         * Adx 广告位id定向
         */
        private String adxTagIdRule;

        /**
         * 国家定向
         * 为空表示不限 1- 白名单，2- 黑名单
         */
        private String country;

        /**
         * 百度looklike定向。 为空则是不定向
         * 定向类型定义：1.通用 2.会籍卡 3.盲盒
         * 定向阈值定义：
         * 1. 50<=相似度<60
         * 2. 60<=相似度<70
         * 3. 70<=相似度<80
         * 4. 80<=相似度<90
         * 5. 90<=相似度<=100
         */
        private String baiduLookLikeRule;


        public String getCountry() {
            return country;
        }

        public void setCountry(String country) {
            this.country = country;
        }

        public String getBaiduLookLikeRule() {
            return baiduLookLikeRule;
        }

        public void setBaiduLookLikeRule(String baiduLookLikeRule) {
            this.baiduLookLikeRule = baiduLookLikeRule;
        }

        public String getAdxTagIdRule() {
            return adxTagIdRule;
        }

        public void setAdxTagIdRule(String adxTagIdRule) {
            this.adxTagIdRule = adxTagIdRule;
        }

        public String getAppIdPackage() {
            return appIdPackage;
        }

        public void setAppIdPackage(String appIdPackage) {
            this.appIdPackage = appIdPackage;
        }

        public String getAdxAPPEntranceRule() {
            return adxAPPEntranceRule;
        }

        public void setAdxAPPEntranceRule(String adxAPPEntranceRule) {
            this.adxAPPEntranceRule = adxAPPEntranceRule;
        }

        public String getBesGender() {
            return besGender;
        }

        public void setBesGender(String besGender) {
            this.besGender = besGender;
        }

        public String getBesAge() {
            return besAge;
        }

        public void setBesAge(String besAge) {
            this.besAge = besAge;
        }

        public String getPhoneBrand() {
            return phoneBrand;
        }

        public void setPhoneBrand(String phoneBrand) {
            this.phoneBrand = phoneBrand;
        }

        public String getGetuiSex() {
            return getuiSex;
        }

        public void setGetuiSex(String getuiSex) {
            this.getuiSex = getuiSex;
        }

        public String getNetworkType() {
            return networkType;
        }

        public void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        public String getAdQuality() {
            return adQuality;
        }

        public void setAdQuality(String adQuality) {
            this.adQuality = adQuality;
        }

        public String getActivityOrientation() {
            return activityOrientation;
        }

        public void setActivityOrientation(String activityOrientation) {
            this.activityOrientation = activityOrientation;
        }

        public String getPersonsGrade() {
            return personsGrade;
        }

        public void setPersonsGrade(String personsGrade) {
            this.personsGrade = personsGrade;
        }

        public String getTimes() {
            return times;
        }

        public void setTimes(String times) {
            this.times = times;
        }

        public String getBanners() {
            return banners;
        }

        public void setBanners(String banners) {
            this.banners = banners;
        }

        public String getNoimei() {
            return noimei;
        }

        public void setNoimei(String noimei) {
            this.noimei = noimei;
        }

        public String getImeinomatching() {
            return imeinomatching;
        }

        public void setImeinomatching(String imeinomatching) {
            this.imeinomatching = imeinomatching;
        }

        public String getFrequencys() {
            return frequencys;
        }

        public void setFrequencys(String frequencys) {
            this.frequencys = frequencys;
        }

        public Boolean getBooleanTimes() {
            return booleanTimes==null?false:booleanTimes;
        }

        public void setBooleanTimes(Boolean booleanTimes) {
            this.booleanTimes = booleanTimes;
        }

        public String getTimeBidding() {
            return timeBidding;
        }

        public void setTimeBidding(String timeBidding) {
            this.timeBidding = timeBidding;
        }

        public String getCrowdPackage() {
            return crowdPackage;
        }

        public void setCrowdPackage(String crowdPackage) {
            this.crowdPackage = crowdPackage;
        }

        public String getTicketPackage() {
            return ticketPackage;
        }

        public void setTicketPackage(String ticketPackage) {
            this.ticketPackage = ticketPackage;
        }

        public String getAppPackageRule() {
            return appPackageRule;
        }

        public void setAppPackageRule(String appPackageRule) {
            this.appPackageRule = appPackageRule;
        }

        public String getAdxAppIdRule() {
            return adxAppIdRule;
        }

        public void setAdxAppIdRule(String adxAppIdRule) {
            this.adxAppIdRule = adxAppIdRule;
        }

        public String getIsp() {
            return isp;
        }

        public void setIsp(String isp) {
            this.isp = isp;
        }

        public String getNewAndOldUsers() {
            return newAndOldUsers;
        }

        public void setNewAndOldUsers(String newAndOldUsers) {
            this.newAndOldUsers = newAndOldUsers;
        }
    }

    public AdTicketPersonsGradeConf getRef() {
        return ref;
    }

    public void setRef(AdTicketPersonsGradeConf ref) {
        this.ref = ref;
    }

    public String getPersonsGradeConf() {
        return personsGradeConf;
    }

    public void setPersonsGradeConf(String personsGradeConf) {
        this.personsGradeConf = personsGradeConf;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getAdvertiser() {
        return advertiser;
    }

    public void setAdvertiser(Long advertiser) {
        this.advertiser = advertiser;
    }

    public Short getSettleType() {
        return settleType;
    }

    public void setSettleType(Short settleType) {
        this.settleType = settleType;
    }

    public Double getPrice() {
        return price;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public Short getType() {
        return type;
    }

    public void setType(Short type) {
        this.type = type;
    }

    public Double getBudgetDaily() {
        return budgetDaily;
    }

    public void setBudgetDaily(Double budgetDaily) {
        this.budgetDaily = budgetDaily;
    }

    public Integer getConsumeModal() {
        return consumeModal;
    }

    public void setConsumeModal(Integer consumeModal) {
        this.consumeModal = consumeModal;
    }

    public String getDomainCode() {
        return domainCode;
    }

    public void setDomainCode(String domainCode) {
        this.domainCode = domainCode;
    }

    public Double getStandaloneCost() {
        return standaloneCost;
    }

    public void setStandaloneCost(Double standaloneCost) {
        this.standaloneCost = standaloneCost;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Date getValidStartDate() {
        return validStartDate;
    }

    public void setValidStartDate(Date validStartDate) {
        this.validStartDate = validStartDate;
    }

    public Date getValidEndDate() {
        return validEndDate;
    }

    public void setValidEndDate(Date validEndDate) {
        this.validEndDate = validEndDate;
    }

    public Short getIsSupportWechat() {
        return isSupportWechat;
    }

    public void setIsSupportWechat(Short isSupportWechat) {
        this.isSupportWechat = isSupportWechat;
    }

    public Integer getUserGradePassScore() {
        return userGradePassScore;
    }

    public void setUserGradePassScore(Integer userGradePassScore) {
        this.userGradePassScore = userGradePassScore;
    }

    public Short getStatus() {
        return status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    public Integer getPauseReason() {
        return pauseReason;
    }

    public void setPauseReason(Integer pauseReason) {
        this.pauseReason = pauseReason;
    }

    public String getAssetsids() {
        return assetsids;
    }

    public void setAssetsids(String assetsids) {
        this.assetsids = assetsids;
    }

    public ControlDto getControlDto() {
        return controlDto;
    }

    public void setControlDto(ControlDto controlDto) {
        this.controlDto = controlDto;
    }

    public String getTags() {
        return tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getCitys() {
        return citys;
    }

    public void setCitys(String citys) {
        this.citys = citys;
    }

    public String getOss() {
        return oss;
    }

    // 传过来白名单1,2,4 转老系统的黑名单 取非 4对应3
    public String getOldOss() {
        String temp = "1,2,3";
        if (StringUtil.isNotBlank(oss)) {
            if (oss.equals("1,2,4")) {
                return null;
            }
            for (String s : Splitter.on(",").trimResults().split(oss)) {
                if ("4".equals(s)) {
                    temp = temp.replace("3", "");
                } else {
                    temp = temp.replace(s, "");
                }
            }

            temp = Joiner.on(",").join(Splitter.on(",").omitEmptyStrings().split(temp));
        }
        return temp;
    }

    public void setOss(String oss) {
        this.oss = oss;
    }

    public Double getWeight() {
        return weight;
    }

    public void setWeight(Double weight) {
        this.weight = weight;
    }

    public OcpcConfDto getOcpcConf() {
        return ocpcConf;
    }

    public void setOcpcConf(OcpcConfDto ocpcConf) {
        this.ocpcConf = ocpcConf;
    }

    public Boolean getBooleanCitys() {
        return booleanCitys==null?false:booleanCitys;
    }

    public void setBooleanCitys(Boolean booleanCitys) {
        this.booleanCitys = booleanCitys;
    }

    private String log;

    public String getLog() {
        return log;
    }

    public void setLog(String log) {
        this.log = log;
    }

    private String ae;

    public String getAe() {
        return ae;
    }

    public void setAe(String ae) {
        this.ae = ae;
    }

    public String getApps() {
        return apps;
    }

    public void setApps(String apps) {
        this.apps = apps;
    }

    public static class CouponsInfoDto {

        private Short useType;

        private String code;

        @DateTimeFormat(pattern = LocalDateTimeHelper.PATTERN_STR10)
        private Date codeStartTime;

        @DateTimeFormat(pattern = LocalDateTimeHelper.PATTERN_STR10)
        private Date codeEndTime;

        private Integer codeLimitNum;

        private String content;

        private String intro;

        private String packageName;

        //这个是券码文件上传以后返回的keyname
        private String codeKeyName;

        public Short getUseType() {
            return useType;
        }

        public void setUseType(Short useType) {
            this.useType = useType;
        }

        public String getCode() {
            return code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public Date getCodeStartTime() {
            return codeStartTime;
        }

        public void setCodeStartTime(Date codeStartTime) {
            this.codeStartTime = codeStartTime;
        }

        public Date getCodeEndTime() {
            return codeEndTime;
        }

        public void setCodeEndTime(Date codeEndTime) {
            this.codeEndTime = codeEndTime;
        }

        public Integer getCodeLimitNum() {
            return codeLimitNum;
        }

        public void setCodeLimitNum(Integer codeLimitNum) {
            this.codeLimitNum = codeLimitNum;
        }

        public String getContent() {
            return content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String getIntro() {
            return intro;
        }

        public void setIntro(String intro) {
            this.intro = intro;
        }

        public String getPackageName() {
            return packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getCodeKeyName() {
            return codeKeyName;
        }

        public void setCodeKeyName(String codeKeyName) {
            this.codeKeyName = codeKeyName;
        }
    }

    public String getAssetsadxids() {
        return assetsadxids;
    }

    public void setAssetsadxids(String assetsadxids) {
        this.assetsadxids = assetsadxids;
    }

    public AdxConfDto getAdxConfDto() {
        return adxConfDto;
    }

    public void setAdxConfDto(AdxConfDto adxConfDto) {
        this.adxConfDto = adxConfDto;
    }

    public InspireVideoConfDto getInspireVideoConfDto() {
        return inspireVideoConfDto;
    }

    public void setInspireVideoConfDto(InspireVideoConfDto inspireVideoConfDto) {
        this.inspireVideoConfDto = inspireVideoConfDto;
    }

    public TicketAppExtendDto getTicketAppExtendDto() {
        return ticketAppExtendDto;
    }

    public void setTicketAppExtendDto(TicketAppExtendDto ticketAppExtendDto) {
        this.ticketAppExtendDto = ticketAppExtendDto;
    }

    public Integer getPrimaryIndustryId() {
        return primaryIndustryId;
    }

    public void setPrimaryIndustryId(Integer primaryIndustryId) {
        this.primaryIndustryId = primaryIndustryId;
    }

    public Integer getSecondaryIndustryId() {
        return secondaryIndustryId;
    }

    public void setSecondaryIndustryId(Integer secondaryIndustryId) {
        this.secondaryIndustryId = secondaryIndustryId;
    }

    public Integer getIsMeituanReview() {
        return isMeituanReview;
    }

    public void setIsMeituanReview(Integer isMeituanReview) {
        this.isMeituanReview = isMeituanReview;
    }

    public static class AdxConfDto {
        /**
         * 每日最多曝光次数
         */
        private Integer showMaximum;

        /**
         * 每日最多点击次数
         */
        private Integer clickMaximum;

        /**
         * 投放速度：1- 加速投放、2- 匀速投放
         */
        private Short speed;

        /**
         * 结算方式：1- CPC、2- CPA、4- CPM
         */
        private Short adxSettleType;

        /**
         * 单价。单位：厘
         */
        private Double adxPrice;

        /**
         * 日限额（预算），0 表示无限额。单位：厘
         */
        private Double adxBudgetDaily;

        /**
         * adx专员
         */
        private String adxAe;

        /**
         * 投放类型：1，App下载；2，H5；3，deeplink
         */
        private Short adxPutinType;

        /**
         * 下载类型：默认为安卓，1，安卓；2，IOS
         */
        private Short adxDownloadType;

        /**
         * 下载安装包的AppID/包名
         */
        private String adxPackageName;

        /**
         * deeplink地址
         */
        private String deeplinkUrl;

        /**
         * 相关广告位的素材
         * List<AdAssetsAdx>
         * @see com.bxm.adsmanager.model.dao.adkeeper.AdAssetsAdx
         */
        private String assetsAdxArray;

        public Integer getShowMaximum() {
            return showMaximum;
        }

        public void setShowMaximum(Integer showMaximum) {
            this.showMaximum = showMaximum;
        }

        public Integer getClickMaximum() {
            return clickMaximum;
        }

        public void setClickMaximum(Integer clickMaximum) {
            this.clickMaximum = clickMaximum;
        }

        public Short getSpeed() {
            return speed;
        }

        public void setSpeed(Short speed) {
            this.speed = speed;
        }

        public Short getAdxSettleType() {
            return adxSettleType;
        }

        public void setAdxSettleType(Short adxSettleType) {
            this.adxSettleType = adxSettleType;
        }

        public Double getAdxPrice() {
            return adxPrice;
        }

        public void setAdxPrice(Double adxPrice) {
            this.adxPrice = adxPrice;
        }

        public Double getAdxBudgetDaily() {
            return adxBudgetDaily;
        }

        public void setAdxBudgetDaily(Double adxBudgetDaily) {
            this.adxBudgetDaily = adxBudgetDaily;
        }

        public String getAdxAe() {
            return adxAe;
        }

        public void setAdxAe(String adxAe) {
            this.adxAe = adxAe;
        }

        public Short getAdxPutinType() {
            return adxPutinType;
        }

        public void setAdxPutinType(Short adxPutinType) {
            this.adxPutinType = adxPutinType;
        }

        public Short getAdxDownloadType() {
            return adxDownloadType;
        }

        public void setAdxDownloadType(Short adxDownloadType) {
            this.adxDownloadType = adxDownloadType;
        }

        public String getAdxPackageName() {
            return adxPackageName;
        }

        public void setAdxPackageName(String adxPackageName) {
            this.adxPackageName = adxPackageName;
        }

        public String getDeeplinkUrl() {
            return deeplinkUrl;
        }

        public void setDeeplinkUrl(String deeplinkUrl) {
            this.deeplinkUrl = deeplinkUrl;
        }

        public String getAssetsAdxArray() {
            return assetsAdxArray;
        }

        public void setAssetsAdxArray(String assetsAdxArray) {
            this.assetsAdxArray = assetsAdxArray;
        }
    }

    public static class InspireVideoConfDto {
        /**
         * 落地页类型，1下载类，2表单类，3deeplink 5.激励浏览
         */
        private Short pageType;

        /**
         * 下载安装包的AppID/包名
         */
        private String packageName;

        /**
         * 跳转地址
         */
        private String jumpUrl;

        /**
         * 未安装下载地址
         */
        private String unInstallDownloadUrl;

        /**
         * 三方监测渠道，1关闭，2热云，3talking data，4秒针
         */
        private Short thirdPartyChannel;

        /**
         * 曝光监测URL
         */
        private String viewUrl;

        /**
         * 点击监测URL
         */
        private String clickUrl;

        /**
         * 视频开始播放地址监测URL
         */
        private String videoPlayStartUrl;

        /**
         * 视频播放完成地址监测URL
         */
        private String videoPlayEndUrl;

        /**
         * 相关广告位的素材
         * List<AdAssetsInspireVideo>
         * @see com.bxm.adsmanager.model.dao.adkeeper.AdAssetsInspireVideo
         */
        private String assetsInspireVideoArray;

        public Short getPageType() {
            return pageType;
        }

        public void setPageType(Short pageType) {
            this.pageType = pageType;
        }

        public String getPackageName() {
            return packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getJumpUrl() {
            return jumpUrl;
        }

        public void setJumpUrl(String jumpUrl) {
            this.jumpUrl = jumpUrl;
        }

        public String getUnInstallDownloadUrl() {
            return unInstallDownloadUrl;
        }

        public void setUnInstallDownloadUrl(String unInstallDownloadUrl) {
            this.unInstallDownloadUrl = unInstallDownloadUrl;
        }

        public Short getThirdPartyChannel() {
            return thirdPartyChannel;
        }

        public void setThirdPartyChannel(Short thirdPartyChannel) {
            this.thirdPartyChannel = thirdPartyChannel;
        }

        public String getViewUrl() {
            return viewUrl;
        }

        public void setViewUrl(String viewUrl) {
            this.viewUrl = viewUrl;
        }

        public String getClickUrl() {
            return clickUrl;
        }

        public void setClickUrl(String clickUrl) {
            this.clickUrl = clickUrl;
        }

        public String getVideoPlayStartUrl() {
            return videoPlayStartUrl;
        }

        public void setVideoPlayStartUrl(String videoPlayStartUrl) {
            this.videoPlayStartUrl = videoPlayStartUrl;
        }

        public String getVideoPlayEndUrl() {
            return videoPlayEndUrl;
        }

        public void setVideoPlayEndUrl(String videoPlayEndUrl) {
            this.videoPlayEndUrl = videoPlayEndUrl;
        }

        public String getAssetsInspireVideoArray() {
            return assetsInspireVideoArray;
        }

        public void setAssetsInspireVideoArray(String assetsInspireVideoArray) {
            this.assetsInspireVideoArray = assetsInspireVideoArray;
        }
    }

    /**
     * ticket app扩展内容
     */
    public static class TicketAppExtendDto {
        /**
         * 落地页类型，1下载类，2表单类，3deeplink 5.激励浏览
         */
        private Short pageType;

        /**
         * 下载安装包的AppID/包名
         */
        private String packageName;

        /**
         * 跳转地址
         */
        private String jumpUrl;

        /**
         * 未安装下载地址
         */
        private String unInstallDownloadUrl;

        /**
         * 三方监测渠道，1关闭，2热云，3talking data，4秒针
         */
        private Short thirdPartyChannel;

        /**
         * 曝光监测URL
         */
        private String viewUrl;

        /**
         * 点击监测URL
         */
        private String clickUrl;

        /**
         * 视频开始播放地址监测URL
         */
        private String videoPlayStartUrl;

        /**
         * 视频播放完成地址监测URL
         */
        private String videoPlayEndUrl;

        /**
         * deeplink吊起开始监测URL
         */
        private String deeplinkStartUrl;

        /**
         * deeplink吊起成功监测URL
         */
        private String deeplinkSuccessUrl;

        /**
         * deeplink吊起失败监测URL
         */
        private String deeplinkFailUrl;

        /**
         * 未获取到App列表时投放配率
         */
        private Integer appPackageRate;

        /**
         *  设备号定向 1.不限  2.仅设备号的流量
         */
        private String deviceOrientation;

        /**
         * 相关广告位的素材
         * List<AdAssetsInspireVideo>
         * @see com.bxm.adsmanager.model.dao.adkeeper.AdAssetsInspireVideo
         */
        private String assetsInspireVideoArray;

        /**
         * 媒体app包名定向
         */
        private String mediaAppPackageRule;

        /**
         * 无包名投放配率 0到100
         */
        private Integer mediaAppPackageRate;

        /**
         * Adx无App ID 投放配率： 0到100
         */
        private Integer adxAppIdRate;

        /**
         * 百度标签定向，多个用逗号分隔
         */
        private String bdTagsOrientation;

        /**
         * 百度BES广告标签
         */
        private String bdTags;

        /**
         * ADX CPM成本
         */
        private Double adxPrice;

        /**
         * adx出价类型
         * @see com.bxm.adsmanager.model.enums.AdxPriceTypeEnum
         */
        private Short adxPriceType;

        /**
         * adx 出价目标cpa,单位：厘
         */
        private Double adxTargetCpa;

        /**
         * ADX成本日预算
         */
        private Double adxBudgetDaily;

        /**
         * 落地页最后一跳地址
         */
        private String landingPageEndJumpUrl;

        /**
         * RTA定向
         */
        private Integer rta;

        /**
         * RTA参数
         */
        private String rtaParam;

        /**
         * 下载落地页ID
         */
        private Long downloadLandingPageId;

        /**
         * 人群包定向,多个逗号分隔
         */
        private String crowdPackageOrientation;

        /**
         * adxId 用于素材审核时判断是哪个Adx，也用于不同adx对素材进行不同的逻辑处理
         * @see //com.bxm.adsmanager.model.enums.AdxIdEnum
         */
        private Short adxId;

        /**
         * 风控：0关闭，1开启
         */
        private Short riskControl;

        /**
         * 首唤优化：0关闭，1开启
         */
        private Short firstCallOptimization;

        /**
         * 活动参与率，0-100之间的整数
         */
        private Short participationRate;

        /**
         * 操作系统版本定向（最低值）
         */
        private String osVersionOrientation;

        /**
         * 淘宝商详率，实际使用时需要除以10000
         */
        private Double tbWaresDetailRate;

        /**
         * 淘宝首唤率*商详率，实际使用时需要除以10000
         */
        private Double tbFirstCallAndWaresDetailRate;

        /**
         * 一键复苏开关：0关闭，1开启
         */
        private Short oneClickRecovery;

        /**
         * ROI系数，正数，精确到两位小数
         */
        private Double roiCoefficient;

        /**
         * 百度标签定向（新），格式如：{白名单且}-{白名单且},{白名单或}-{白名单或}&{黑名单且}-{黑名单且},{黑名单或}-{黑名单或}
         */
        private String besTagsOrientation;

        /**
         * ADX App跑量覆盖，正数，精确到1位小数
         */
        private Double adxAppRvCover;

        /**
         * 无广告位id投放配率
         */
        private Integer adxTagIdRate;

        /**
         * 是否支持 oCPR  0.否 1.是
         */
        private Short supportOcpr;

        public Short getSupportOcpr() {
            return supportOcpr;
        }

        public void setSupportOcpr(Short supportOcpr) {
            this.supportOcpr = supportOcpr;
        }

        public Integer getAdxTagIdRate() {
            return adxTagIdRate;
        }

        public void setAdxTagIdRate(Integer adxTagIdRate) {
            this.adxTagIdRate = adxTagIdRate;
        }


        public Double getAdxAppRvCover() {
            return adxAppRvCover;
        }

        public void setAdxAppRvCover(Double adxAppRvCover) {
            this.adxAppRvCover = adxAppRvCover;
        }

        public Double getRoiCoefficient() {
            return roiCoefficient;
        }

        public void setRoiCoefficient(Double roiCoefficient) {
            this.roiCoefficient = roiCoefficient;
        }

        public String getBesTagsOrientation() {
            return besTagsOrientation;
        }

        public void setBesTagsOrientation(String besTagsOrientation) {
            this.besTagsOrientation = besTagsOrientation;
        }

        public Short getOneClickRecovery() {
            return oneClickRecovery;
        }

        public void setOneClickRecovery(Short oneClickRecovery) {
            this.oneClickRecovery = oneClickRecovery;
        }

        public Double getTbFirstCallAndWaresDetailRate() {
            return tbFirstCallAndWaresDetailRate;
        }

        public void setTbFirstCallAndWaresDetailRate(Double tbFirstCallAndWaresDetailRate) {
            this.tbFirstCallAndWaresDetailRate = tbFirstCallAndWaresDetailRate;
        }

        public Double getTbWaresDetailRate() {
            return tbWaresDetailRate;
        }

        public void setTbWaresDetailRate(Double tbWaresDetailRate) {
            this.tbWaresDetailRate = tbWaresDetailRate;
        }

        public String getOsVersionOrientation() {
            return osVersionOrientation;
        }

        public void setOsVersionOrientation(String osVersionOrientation) {
            this.osVersionOrientation = osVersionOrientation;
        }

        public Short getParticipationRate() {
            return participationRate;
        }

        public void setParticipationRate(Short participationRate) {
            this.participationRate = participationRate;
        }

        public Short getFirstCallOptimization() {
            return firstCallOptimization;
        }

        public void setFirstCallOptimization(Short firstCallOptimization) {
            this.firstCallOptimization = firstCallOptimization;
        }

        public Short getRiskControl() {
            return riskControl;
        }

        public void setRiskControl(Short riskControl) {
            this.riskControl = riskControl;
        }

        public Short getAdxId() {
            return adxId;
        }

        public void setAdxId(Short adxId) {
            this.adxId = adxId;
        }

        public String getCrowdPackageOrientation() {
            return crowdPackageOrientation;
        }

        public void setCrowdPackageOrientation(String crowdPackageOrientation) {
            this.crowdPackageOrientation = crowdPackageOrientation;
        }

        public Long getDownloadLandingPageId() {
            return downloadLandingPageId;
        }

        public void setDownloadLandingPageId(Long downloadLandingPageId) {
            this.downloadLandingPageId = downloadLandingPageId;
        }

        public Short getAdxPriceType() {
            return adxPriceType;
        }

        public void setAdxPriceType(Short adxPriceType) {
            this.adxPriceType = adxPriceType;
        }

        public Double getAdxTargetCpa() {
            return adxTargetCpa;
        }

        public void setAdxTargetCpa(Double adxTargetCpa) {
            this.adxTargetCpa = adxTargetCpa;
        }

        public Integer getRta() {
            return rta;
        }

        public void setRta(Integer rta) {
            this.rta = rta;
        }

        public String getRtaParam() {
            return rtaParam;
        }

        public void setRtaParam(String rtaParam) {
            this.rtaParam = rtaParam;
        }


        public Integer getAdxAppIdRate() {
            return adxAppIdRate;
        }

        public void setAdxAppIdRate(Integer adxAppIdRate) {
            this.adxAppIdRate = adxAppIdRate;
        }

        public String getBdTagsOrientation() {
            return bdTagsOrientation;
        }

        public void setBdTagsOrientation(String bdTagsOrientation) {
            this.bdTagsOrientation = bdTagsOrientation;
        }

        public String getLandingPageEndJumpUrl() {
            return landingPageEndJumpUrl;
        }

        public void setLandingPageEndJumpUrl(String landingPageEndJumpUrl) {
            this.landingPageEndJumpUrl = landingPageEndJumpUrl;
        }

        public String getMediaAppPackageRule() {
            return mediaAppPackageRule;
        }

        public void setMediaAppPackageRule(String mediaAppPackageRule) {
            this.mediaAppPackageRule = mediaAppPackageRule;
        }

        public Integer getMediaAppPackageRate() {
            return mediaAppPackageRate;
        }

        public void setMediaAppPackageRate(Integer mediaAppPackageRate) {
            this.mediaAppPackageRate = mediaAppPackageRate;
        }

        public String getBdTags() {
            return bdTags;
        }

        public void setBdTags(String bdTags) {
            this.bdTags = bdTags;
        }

        public Double getAdxPrice() {
            return adxPrice;
        }

        public void setAdxPrice(Double adxPrice) {
            this.adxPrice = adxPrice;
        }

        public Double getAdxBudgetDaily() {
            return adxBudgetDaily;
        }

        public void setAdxBudgetDaily(Double adxBudgetDaily) {
            this.adxBudgetDaily = adxBudgetDaily;
        }

        public Short getPageType() {
            return pageType;
        }

        public void setPageType(Short pageType) {
            this.pageType = pageType;
        }

        public String getPackageName() {
            return packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getJumpUrl() {
            return jumpUrl;
        }

        public void setJumpUrl(String jumpUrl) {
            this.jumpUrl = jumpUrl;
        }

        public String getUnInstallDownloadUrl() {
            return unInstallDownloadUrl;
        }

        public void setUnInstallDownloadUrl(String unInstallDownloadUrl) {
            this.unInstallDownloadUrl = unInstallDownloadUrl;
        }

        public Short getThirdPartyChannel() {
            return thirdPartyChannel;
        }

        public void setThirdPartyChannel(Short thirdPartyChannel) {
            this.thirdPartyChannel = thirdPartyChannel;
        }

        public String getViewUrl() {
            return viewUrl;
        }

        public void setViewUrl(String viewUrl) {
            this.viewUrl = viewUrl;
        }

        public String getClickUrl() {
            return clickUrl;
        }

        public void setClickUrl(String clickUrl) {
            this.clickUrl = clickUrl;
        }

        public String getVideoPlayStartUrl() {
            return videoPlayStartUrl;
        }

        public void setVideoPlayStartUrl(String videoPlayStartUrl) {
            this.videoPlayStartUrl = videoPlayStartUrl;
        }

        public String getVideoPlayEndUrl() {
            return videoPlayEndUrl;
        }

        public void setVideoPlayEndUrl(String videoPlayEndUrl) {
            this.videoPlayEndUrl = videoPlayEndUrl;
        }

        public String getAssetsInspireVideoArray() {
            return assetsInspireVideoArray;
        }

        public void setAssetsInspireVideoArray(String assetsInspireVideoArray) {
            this.assetsInspireVideoArray = assetsInspireVideoArray;
        }

        public String getDeeplinkStartUrl() {
            return deeplinkStartUrl;
        }

        public void setDeeplinkStartUrl(String deeplinkStartUrl) {
            this.deeplinkStartUrl = deeplinkStartUrl;
        }

        public String getDeeplinkSuccessUrl() {
            return deeplinkSuccessUrl;
        }

        public void setDeeplinkSuccessUrl(String deeplinkSuccessUrl) {
            this.deeplinkSuccessUrl = deeplinkSuccessUrl;
        }

        public String getDeeplinkFailUrl() {
            return deeplinkFailUrl;
        }

        public void setDeeplinkFailUrl(String deeplinkFailUrl) {
            this.deeplinkFailUrl = deeplinkFailUrl;
        }

        public Integer getAppPackageRate() {
            return appPackageRate;
        }

        public void setAppPackageRate(Integer appPackageRate) {
            this.appPackageRate = appPackageRate;
        }

        public String getDeviceOrientation() {
            return deviceOrientation;
        }

        public void setDeviceOrientation(String deviceOrientation) {
            this.deviceOrientation = deviceOrientation;
        }
    }

    /*** 添加和修改时的校验组对象定义 ***/
    public interface Add {  }

    public interface Update {   }
}