package com.bxm.adsmanager.model.dto;

import java.io.Serializable;

/**
 * <p>批量添加流量包ID到多个广告券的流量包出价配置明细的前端参数类</p>
 *
 * @author zhengwangeng
 * @date 2019-11-5 14:00
 */
public class AdTicketFlowPackageAddBatchDto implements Serializable {

    private static final long serialVersionUID = 3150888510226003950L;

    /**
     * 广告券ID
     */
    private Long ticketId;

    /**
     * 流量包ID
     */
    private Long flowPackageId;

    /**
     * 出价,单位元
     */
    private String price;

    /**
     * 限额,单位元,infinity:表示不限
     */
    private String quota;

    /**
     * cpa 出价,单位元
     */
    private String cpaPrice;

    /**
     * 深层目标cpa出价,单位元
     */
    private String deepCpaPrice;

    public Long getTicketId() {
        return ticketId;
    }

    public void setTicketId(Long ticketId) {
        this.ticketId = ticketId;
    }

    public Long getFlowPackageId() {
        return flowPackageId;
    }

    public void setFlowPackageId(Long flowPackageId) {
        this.flowPackageId = flowPackageId;
    }

    public String getPrice() {
        return price;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    public String getQuota() {
        return quota;
    }

    public void setQuota(String quota) {
        this.quota = quota;
    }

    public String getCpaPrice() {
        return cpaPrice;
    }

    public void setCpaPrice(String cpaPrice) {
        this.cpaPrice = cpaPrice;
    }

    public String getDeepCpaPrice() {
        return deepCpaPrice;
    }

    public void setDeepCpaPrice(String deepCpaPrice) {
        this.deepCpaPrice = deepCpaPrice;
    }
}
