package com.bxm.adsmanager.model.dto;

import org.hibernate.validator.constraints.NotBlank;

import com.bxm.adsmanager.model.base.BaseDto;

/**
 * <h3>流量包礼券关联表</h3>
 * 
 * @author 拉拉
 * @since V1.0.0, 2017/12/07 18:55
 */
public class AdTicketFlowPackageDto extends BaseDto {

    @NotBlank(message = "流量包id不能为空", groups = { AdTicketFlowPackageDto.Add.class, AdTicketFlowPackageDto.Update.class })
    private String flowPackageIdsAndQuota; // 流量包id和限制额度格式位（id-额度,id-额度）
    @NotBlank(message = "礼券id不能为空", groups = { AdTicketFlowPackageDto.Add.class, AdTicketFlowPackageDto.Update.class })
    private String ticketId;               // 礼券id

    public String getTicketId() {
        return ticketId;
    }

    public void setTicketId(String ticketId) {
        this.ticketId = ticketId;
    }

    /**
     * @return the flowPackageIdsAndQuota
     */
    public String getFlowPackageIdsAndQuota() {
        return flowPackageIdsAndQuota;
    }

    /**
     * @param flowPackageIdsAndQuota the flowPackageIdsAndQuota to set
     */
    public void setFlowPackageIdsAndQuota(String flowPackageIdsAndQuota) {
        this.flowPackageIdsAndQuota = flowPackageIdsAndQuota;
    }

    public interface Add {
    }

    public interface Update {
    }
}
