package com.bxm.adsmanager.model.dto;

import com.bxm.adsmanager.model.base.BaseDto;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketPersonsGradeConf;
import com.bxm.util.StringUtil;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import org.hibernate.validator.constraints.NotBlank;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * <h3>广告券的弹窗</h3>
 * @author 拉拉
 * @since V1.0.0, 2017/12/07 18:55
 */
public class AdTicketPopupDto extends BaseDto {

	@NotBlank(message = "媒体入口不能为空", groups = {AdTicketPopupDto.Add.class,AdTicketPopupDto.Update.class})
	private String positionId;//媒体入口
	//@NotBlank(message = "礼券id不能为空", groups = {AdTicketPopupDto.Add.class,AdTicketPopupDto.Update.class})
	private String ticketIds;//礼券id
	private Integer sequence;//顺序
	@NotNull(message = "弹窗类型（1首页弹窗）不能为空", groups = {AdTicketPopupDto.Add.class,AdTicketPopupDto.Update.class})
	private Integer scene;//弹窗类型（1首页弹窗）

	private String appName;//app名称

	private String  ticketId;//单个礼券id

	private String  ticketName;//单个礼券id
	private String  businessId;//入口id

	 
	
    /**
     * @return the positionId
     */
    public String getPositionId() {
        return positionId;
    }

    
    /**
     * @param positionId the positionId to set
     */
    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public String getTicketName() {
		return ticketName;
	}

	public void setTicketName(String ticketName) {
		this.ticketName = ticketName;
	}

	public String getTicketIds() {
		return ticketIds;
	}

	public void setTicketIds(String ticketIds) {
		this.ticketIds = ticketIds;
	}

	public Integer getSequence() {
		return sequence;
	}

	public void setSequence(Integer sequence) {
		this.sequence = sequence;
	}

	public Integer getScene() {
		return scene;
	}

	public void setScene(Integer scene) {
		this.scene = scene;
	}

	public String getAppName() {
		return appName;
	}

	public void setAppName(String appName) {
		this.appName = appName;
	}

	public String getTicketId() {
		return ticketId;
	}

	public void setTicketId(String ticketId) {
		this.ticketId = ticketId;
	}

	public String getBusinessId() {
		return businessId;
	}

	public void setBusinessId(String businessId) {
		this.businessId = businessId;
	}

	public interface Add{}
	public interface Update{}
}
