package com.bxm.adsmanager.model.dto;
/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */


import java.util.List;

import com.bxm.adsmanager.model.base.BaseDto;

/**
 * <h3>广告券列表展示页查询类</h3>
 * @author hcmony
 * @since V1.0.0, 2017/12/13 21:52
 */
public class AdTicketSearchDto extends BaseDto{

	/**
	 * //结算方式：1- CPC、2- CPA、4- CPM
	 */
	private Short settleType;

	/**
	 * 广告券类型
	 */
	private Short type;

	private Short status;

	/**
	 * 暂停原因。1- 超出预算、2- 余额不足
	 */
	private Integer pauseReason;

	/**
	 * 状态码
	 */
	private String statusCode;

	private String ae;

	private String sale;

	private List<Long> list;

	private Short dealStatus;

	private List<Short> statusList;

	private List<Long> notInList;

	/**
	 * 广告主id或者名称
	 */
	private String advertiseIdOrName;

	/**
	 * 查询开始时间
	 */
	private String pvStartTime;
	/**
	 * 查询结束时间
	 */
	private String  pvEndTime;

	/**
	 * 广告主id
	 */
	private Integer advertiserId;

	/**
	 * 排序字段
	 */
	private String sortName;

	/**
	 * 排序方式
	 */
	private String sortType;
	
	/**
	 * 区分待处理列表和处理过的列表，0-未处理 1-处理过
	 */
	private String isDeal;

	/**
	 * 低于预设点击率的素材的标识符 1-查询  0-不查询
	 */
	private String assetsLowClickRate;

    /**
     * 广告券类别
     */
	private Integer tagCode;

	private String tagCodes;

    /**
     * 券ID集合
     */
	private List<Long> ticketIds;

	/**
	 * 这个是前端页面传递
	 */
	private String ticketStrIds;

	/**
	 * 查询ocpc券
	 */
    private Boolean ocpcTicket;

    private List<Long> excludeTicketIds;

	/**
	 * ocpc阶段
	 */
	private Integer ocpcStage;

    private String createUser;

	/**
	 * //券id或者名称
	 */
	private String ticketIdOrName;

	@Deprecated
	/**
	 * 券类型，多个以逗号隔开
	 */
    private String types;

	/**
	 * //广告券类型。
	 */
	private List<Short> typeList;

	/**
	 * 关键字列表
	 */
	private List<String> keywordsList;

	/**
	 * 风控：0关闭，1开启
	 */
	private Short riskControl;

	/**
	 * 首唤优化：0关闭，1开启
	 */
	private Short firstCallOptimization;

	public Short getFirstCallOptimization() {
		return firstCallOptimization;
	}

	public void setFirstCallOptimization(Short firstCallOptimization) {
		this.firstCallOptimization = firstCallOptimization;
	}

	public Short getRiskControl() {
		return riskControl;
	}

	public void setRiskControl(Short riskControl) {
		this.riskControl = riskControl;
	}

	public List<String> getKeywordsList() {
		return keywordsList;
	}

	public void setKeywordsList(List<String> keywordsList) {
		this.keywordsList = keywordsList;
	}

	public List<Short> getTypeList() {
		return typeList;
	}

	public void setTypeList(List<Short> typeList) {
		this.typeList = typeList;
	}

	public String getTicketIdOrName() {
		return ticketIdOrName;
	}

	public void setTicketIdOrName(String ticketIdOrName) {
		this.ticketIdOrName = ticketIdOrName;
	}

	public String getTypes() {
		return types;
	}

	public void setTypes(String types) {
		this.types = types;
	}

	public String getAdvertiseIdOrName() {
		return advertiseIdOrName;
	}

	public void setAdvertiseIdOrName(String advertiseIdOrName) {
		this.advertiseIdOrName = advertiseIdOrName;
	}

	public String getSortName() {
		return sortName;
	}

	public void setSortName(String sortName) {
		this.sortName = sortName;
	}

	public String getSortType() {
		return sortType;
	}

	public void setSortType(String sortType) {
		this.sortType = sortType;
	}

	public Short getSettleType() {
		return settleType;
	}

	public void setSettleType(Short settleType) {
		this.settleType = settleType;
	}

	public Short getType() {
		return type;
	}

	public void setType(Short type) {
		this.type = type;
	}

	public String getStatusCode() {
		return statusCode;
	}

	public void setStatusCode(String statusCode) {
		this.statusCode = statusCode;
	}

	public String getAe() {
		return ae;
	}

	public void setAe(String ae) {
		this.ae = ae;
	}

	public String getSale() {
		return sale;
	}

	public void setSale(String sale) {
		this.sale = sale;
	}

	public String getPvStartTime() {
		return pvStartTime;
	}

	public void setPvStartTime(String pvStartTime) {
		this.pvStartTime = pvStartTime;
	}

	public String getPvEndTime() {
		return pvEndTime;
	}

	public void setPvEndTime(String pvEndTime) {
		this.pvEndTime = pvEndTime;
	}

	public List<Long> getList() {
		return list;
	}

	public void setList(List<Long> list) {
		this.list = list;
	}

	public Short getStatus() {
		return status;
	}

	public void setStatus(Short status) {
		this.status = status;
	}

	public Integer getPauseReason() {
		return pauseReason;
	}

	public void setPauseReason(Integer pauseReason) {
		this.pauseReason = pauseReason;
	}

	public Integer getAdvertiserId() {
		return advertiserId;
	}

	public void setAdvertiserId(Integer advertiserId) {
		this.advertiserId = advertiserId;
	}

    public String getIsDeal() {
        return isDeal;
    }

    public void setIsDeal(String isDeal) {
        this.isDeal = isDeal;
    }

    public String getAssetsLowClickRate() {
        return assetsLowClickRate;
    }

    public void setAssetsLowClickRate(String assetsLowClickRate) {
        this.assetsLowClickRate = assetsLowClickRate;
    }

    public Integer getTagCode() {
        return tagCode;
    }

    public void setTagCode(Integer tagCode) {
        this.tagCode = tagCode;
    }

    public List<Long> getTicketIds() {
        return ticketIds;
    }

    public void setTicketIds(List<Long> ticketIds) {
        this.ticketIds = ticketIds;
    }

	public Short getDealStatus() {
		return dealStatus;
	}

	public void setDealStatus(Short dealStatus) {
		this.dealStatus = dealStatus;
	}

	public List<Short> getStatusList() {
		return statusList;
	}

	public void setStatusList(List<Short> statusList) {
		this.statusList = statusList;
	}

	public List<Long> getNotInList() {
		return notInList;
	}

	public void setNotInList(List<Long> notInList) {
		this.notInList = notInList;
	}

	public String getTagCodes() {
		return tagCodes;
	}

	public void setTagCodes(String tagCodes) {
		this.tagCodes = tagCodes;
	}

	public String getTicketStrIds() {
		return ticketStrIds;
	}

	public void setTicketStrIds(String ticketStrIds) {
		this.ticketStrIds = ticketStrIds;
	}

    public Boolean getOcpcTicket() {
        return ocpcTicket;
    }

    public void setOcpcTicket(Boolean ocpcTicket) {
        this.ocpcTicket = ocpcTicket;
    }

    public List<Long> getExcludeTicketIds() {
        return excludeTicketIds;
    }

    public void setExcludeTicketIds(List<Long> excludeTicketIds) {
        this.excludeTicketIds = excludeTicketIds;
    }

    public Integer getOcpcStage() {
        return ocpcStage;
    }

    public void setOcpcStage(Integer ocpcStage) {
        this.ocpcStage = ocpcStage;
    }

    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }
}
