package com.bxm.adsmanager.model.dto;

import javax.validation.constraints.NotNull;

import com.bxm.adsmanager.model.base.BaseDto;

public class AdTicketThirdPartyCrowdPackageDto extends BaseDto {

    /**
     * 人群包名称
     */
    @NotNull(message = "人群包名称不能为空", groups = { AdTicketThirdPartyCrowdPackageDto.Add.class, AdTicketThirdPartyCrowdPackageDto.Update.class })
    private String packageName;

    /**
     * 所属项目：1ADX，2激励视频
     */
    @NotNull(message = "所属项目不能为空", groups = { AdTicketThirdPartyCrowdPackageDto.Add.class, AdTicketThirdPartyCrowdPackageDto.Update.class })
    private Short projectType;

    /**
     * 人群包来源：1个推
     */
    @NotNull(message = "人群包来源不能为空", groups = { AdTicketThirdPartyCrowdPackageDto.Add.class, AdTicketThirdPartyCrowdPackageDto.Update.class })
    private Short packageSource;

    /**
     * 外部人群包ID
     */
    @NotNull(message = "外部人群包ID不能为空", groups = { AdTicketThirdPartyCrowdPackageDto.Add.class, AdTicketThirdPartyCrowdPackageDto.Update.class })
    private String thirdPartyPackageId;

    /**
     * 外部人群标签类型：1-TA标签；2-其它
     */
    @NotNull(message = "外部人群标签类型不能为空", groups = { AdTicketThirdPartyCrowdPackageDto.Add.class, AdTicketThirdPartyCrowdPackageDto.Update.class })
    private Short tagType;

    /**
     * 标签,JSON字符串
     */
    private String tags;

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public Short getProjectType() {
        return projectType;
    }

    public void setProjectType(Short projectType) {
        this.projectType = projectType;
    }

    public Short getPackageSource() {
        return packageSource;
    }

    public void setPackageSource(Short packageSource) {
        this.packageSource = packageSource;
    }

    public String getThirdPartyPackageId() {
        return thirdPartyPackageId;
    }

    public void setThirdPartyPackageId(String thirdPartyPackageId) {
        this.thirdPartyPackageId = thirdPartyPackageId;
    }

    public Short getTagType() {
        return tagType;
    }

    public void setTagType(Short tagType) {
        this.tagType = tagType;
    }

    public String getTags() {
        return tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public interface Add {  }

    public interface Update {   }

}
