package com.bxm.adsmanager.model.dto;

import java.io.Serializable;
import java.math.BigDecimal;

import javax.validation.constraints.NotNull;

import lombok.Data;

/**
 * 代理渠道.</br>
 * Created by zhengwangeng on 2021/11/10.
 */
@Data
public class AgencyChannelDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @NotNull(message = "ID不能为空", groups = { AgencyChannelDTO.Update.class })
    private Long id;

    /**
     * 代理名称
     */
    @NotNull(message = "代理名称不能为空", groups = { AgencyChannelDTO.Add.class, AgencyChannelDTO.Update.class })
    private String agencyName;

    /**
     * 产品名称
     */
    @NotNull(message = "产品名称不能为空", groups = { AgencyChannelDTO.Add.class, AgencyChannelDTO.Update.class })
    private String productName;

    /**
     * 渠道号
     */
    @NotNull(message = "渠道号不能为空", groups = { AgencyChannelDTO.Add.class, AgencyChannelDTO.Update.class })
    private String channelNo;

    /**
     * 链接类型
     */
    @NotNull(message = "链接类型不能为空", groups = { AgencyChannelDTO.Add.class, AgencyChannelDTO.Update.class })
    private String linkType;

    /**
     * 链接地址
     */
    @NotNull(message = "链接地址不能为空", groups = { AgencyChannelDTO.Add.class, AgencyChannelDTO.Update.class })
    private String linkUrl;

    /**
     * 所属业务线
     */
    @NotNull(message = "所属业务线不能为空", groups = { AgencyChannelDTO.Add.class, AgencyChannelDTO.Update.class })
    private String ownedBusiness;

    /**
     * 券ID
     */
    private Long ticketId;

    /**
     * 归属者
     */
    @NotNull(message = "归属者不能为空", groups = { AgencyChannelDTO.Add.class, AgencyChannelDTO.Update.class })
    private String belonger;

    /**
     * 销售
     */
    private String sale;

    /**
     * 代理人code，系统内媒介和销售角色的用户code
     */
    private String proxyCode;

    /**
     * 下游代理code
     */
    private String nextProxyCode;


    public interface Add {  }

    public interface Update {   }
}
