package com.bxm.adsmanager.model.dto;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import javax.validation.constraints.NotNull;

import lombok.Data;

/**
 * 代理渠道数据.</br>
 * Created by zhengwangeng on 2021/11/10.
 */
@Data
public class AgencyChannelDataBatchUpdateDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @NotNull(message = "ID不能为空", groups = { AgencyChannelDataBatchUpdateDTO.Update.class })
    private List<Long> ids;

    /**
     * 有效点击单价
     */
    private BigDecimal validClickPrice;

    /**
     * 质量系数
     */
    private BigDecimal qualityFactor;

    /**
     * 备注
     */
    private String remark;

    public interface Update {   }
}
