package com.bxm.adsmanager.model.dto;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;

import org.springframework.format.annotation.DateTimeFormat;

import com.bxm.warcar.utils.localdate.LocalDateTimeHelper;
import com.fasterxml.jackson.annotation.JsonFormat;

import cn.afterturn.easypoi.excel.annotation.Excel;
import lombok.Data;

/**
 * 代理渠道数据.</br>
 * Created by zhengwangeng on 2021/11/10.
 */
@Data
public class AgencyChannelDataDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @NotNull(message = "ID不能为空", groups = { AgencyChannelDataDTO.Update.class })
    private Long id;

    /**
     * 日期
     */
    @NotNull(message = "日期不能为空", groups = { AgencyChannelDataDTO.Add.class, AgencyChannelDataDTO.Update.class })
    @DateTimeFormat(pattern = LocalDateTimeHelper.PATTERN_STR10)
    @JsonFormat(pattern = LocalDateTimeHelper.PATTERN_STR10, timezone = "GMT+8")
    private Date thedate;

    /**
     * 代理名称
     */
    @NotNull(message = "代理名称不能为空", groups = { AgencyChannelDataDTO.Add.class, AgencyChannelDataDTO.Update.class })
    private String agencyName;

    /**
     * 渠道号
     */
    @NotNull(message = "渠道号不能为空", groups = { AgencyChannelDataDTO.Add.class, AgencyChannelDataDTO.Update.class })
    private String channelNo;

    /**
     * 收入
     */
    @NotNull(message = "收入不能为空", groups = { AgencyChannelDataDTO.Add.class, AgencyChannelDataDTO.Update.class })
    private BigDecimal income;

    /**
     * 有效点击单价
     */
    private BigDecimal validClickPrice;

    /**
     * 有效点击
     */
    private Long validClick;

    /**
     * 质量系数
     */
    private BigDecimal qualityFactor;

    /**
     * CPS佣金
     */
    private BigDecimal cpsBrokerage;

    /**
     * 成本
     */
    private BigDecimal cost;

    /**
     * 核减风险：0无，1有
     */
    private Byte riskReduction = 0;

    /**
     * 质量分1
     */
    private BigDecimal qualityScoreOne;

    /**
     * 质量分2
     */
    private BigDecimal qualityScoreTwo;

    /**
     * 质量分3
     */
    private BigDecimal qualityScoreThree;

    /**
     * 质量分4
     */
    private BigDecimal qualityScoreFour;

    /**
     * 备注
     */
    private String remark;

    /**
     * 归属者
     */
    @NotNull(message = "归属者不能为空", groups = { AgencyChannelDataDTO.Add.class, AgencyChannelDataDTO.Update.class })
    private String belonger;

    /**
     * 所属业务线 1.rtb 2.sdk 3.dsp 4.联盟开户 5.外放代理
     */
    private String ownedBusiness;

    /**
     * 外放代理人code，系统内媒介和销售角色的用户code
     */
    private String proxyCode;

    /**
     * 下游代理code，系统字典-代理下游子类字典code
     */
    private String nextProxyCode;

    public interface Add {  }

    public interface Update {   }
}
