package com.bxm.adsmanager.model.dto;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;

import cn.afterturn.easypoi.excel.annotation.Excel;
import lombok.Data;

/**
 * 代理渠道数据.</br>
 * Created by zhengwangeng on 2021/11/10.
 */
@Data
public class AgencyChannelDataImportExcelDTO implements Serializable {

    private static final long serialVersionUID = 1L;

//    @NotNull(message = "日期不能为空")
    @Excel(name = "日期")
    private Date thedate;

//    @NotNull(message = "代理名称不能为空")
    @Excel(name = "代理名称")
    private String agencyName;

//    @NotNull(message = "渠道号不能为空")
    @Excel(name = "渠道号")
    private String channelNo;

//    @NotNull(message = "收入不能为空")
    @Excel(name = "收入")
    private BigDecimal income;

    @Excel(name = "有效点击单价")
    private BigDecimal validClickPrice;

    @Excel(name = "有效点击")
    private Long validClick;

    @Excel(name = "质量系数")
    private BigDecimal qualityFactor;

    @Excel(name = "CPS佣金")
    private BigDecimal cpsBrokerage;

    @Excel(name = "成本")
    private BigDecimal cost;

    @Excel(name = "质量分1")
    @Digits(integer = 3, fraction = 2, message = "质量分1整数位最多3位,小数位最多2位")
    @DecimalMin(value = "0", message = "质量分1不能为负数")
    private BigDecimal qualityScoreOne;

    @Excel(name = "质量分2")
    @Digits(integer = 3, fraction = 2, message = "质量分2整数位最多3位,小数位最多2位")
    @DecimalMin(value = "0", message = "质量分2不能为负数")
    private BigDecimal qualityScoreTwo;

    @Excel(name = "质量分3")
    @Digits(integer = 3, fraction = 2, message = "质量分3整数位最多3位,小数位最多2位")
    @DecimalMin(value = "0", message = "质量分3不能为负数")
    private BigDecimal qualityScoreThree;

    @Excel(name = "质量分4")
    @Digits(integer = 3, fraction = 2, message = "质量分4整数位最多3位,小数位最多2位")
    @DecimalMin(value = "0", message = "质量分4不能为负数")
    private BigDecimal qualityScoreFour;

    @Excel(name = "备注")
    private String remark;

    /**
     * 所属业务线 1.rtb 2.sdk 3.dsp 4.联盟开户 5.外放代理
     */
    private String ownedBusiness;

    /**
     * 外放代理人code，系统内媒介和销售角色的用户code
     */
    private String proxyCode;

    /**
     * 下游代理人code，系统字典-代理下游子类字典code
     */
    private String nextProxyCode;
}
