package com.bxm.adsmanager.model.dto;

import java.io.Serializable;
import java.util.List;
import java.util.Set;

import com.bxm.adsmanager.model.base.BaseDto;

import lombok.Data;

/**
 * 代理渠道数据.</br>
 * Created by zhengwangeng on 2021/11/10.
 */
@Data
public class AgencyChannelDataSearchDTO extends BaseDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 日期
     */
    private String thedate;

    /**
     * 代理名称
     */
    private String agencyName;

    /**
     * 渠道号
     */
    private String channelNo;

    /**
     * 核减风险：0无，1有
     */
    private Byte riskReduction;

    /**
     * 数据校验异常：0正常，1异常
     */
    private Byte dataVerifyError;

    /**
     * 归属者
     */
    private String belonger;


    /**
     * 代理名称集合
     */
    private Set<String> agencyNameSet;

    /**
     * 渠道号集合
     */
    private Set<String> channelNoSet;

    /**
     * 排序参数
     */
    private String orderParam = "id";

    /**
     * 排序方式：asc 正序， desc 倒序
     */
    private String orderType = "desc";

}
