package com.bxm.adsmanager.model.dto;

import java.io.Serializable;

import org.hibernate.validator.constraints.NotBlank;

import com.bxm.adsmanager.model.base.BaseDto;

import lombok.Data;

/**
 * 代理渠道数据.</br>
 * Created by zhengwangeng on 2022/1/6.
 */
@Data
public class AgencyChannelDataSyncDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 开始日期
     */
    @NotBlank(message = "开始日期不能为空！")
    private String startTime;

    /**
     * 结束日期
     */
    @NotBlank(message = "结束日期不能为空！")
    private String endTime;
}
