package com.bxm.adsmanager.model.dto;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import javax.validation.constraints.NotNull;

import cn.afterturn.easypoi.excel.annotation.Excel;
import lombok.Data;

/**
 * 代理渠道.</br>
 * Created by zhengwangeng on 2022/3/17.
 */
@Data
public class AgencyChannelImportExcelDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "上游代理名称不能为空")
    @Excel(name = "上游代理名称")
    private String agencyName;

    @NotNull(message = "产品名称不能为空")
    @Excel(name = "产品名称")
    private String productName;

    @NotNull(message = "渠道号不能为空")
    @Excel(name = "渠道号")
    private String channelNo;

    @NotNull(message = "链接类型不能为空")
    @Excel(name = "链接类型",replace = {"拉新_1", "拉活_2", "其他_0"})
    private String linkType;

    @NotNull(message = "链接地址不能为空")
    @Excel(name = "链接地址")
    private String linkUrl;

    @NotNull(message = "所属业务线不能为空")
    @Excel(name = "所属业务线",replace = {"RTB_1", "SDK_2", "DSP_3","联盟开户_4","外放代理_5"})
    private String ownedBusiness;

    @Excel(name = "券ID（选填）")
    private Long ticketId;

    @Excel(name = "上游销售（选填）")
    private String sale;

    @Excel(name = "外放代理人（所属业务线为外放代理时该字段必填）")
    private String proxyName;

    /**
     * 外放代理人code
     */
    private String proxyCode;

    @Excel(name = "下游代理名称（所属业务线为外放代理时该字段必填）")
    private String nextProxyName;

    /**
     * 下游代理code
     */
    private String nextProxyCode;
}
