package com.bxm.adsmanager.model.dto;

import java.io.Serializable;

import com.bxm.adsmanager.model.base.BaseDto;

import lombok.Data;

/**
 * 代理渠道.</br>
 * Created by zhengwangeng on 2021/11/10.
 */
@Data
public class AgencyChannelSearchDTO extends BaseDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 代理名称
     */
    private String agencyName;

    /**
     * 产品名称
     */
    private String productName;

    /**
     * 渠道号
     */
    private String channelNo;

    /**
     * 所属业务线
     */
    private String ownedBusiness;

    /**
     * 券ID
     */
    private Long ticketId;

    /**
     * 归属者
     */
    private String belonger;

    /**
     * 销售
     */
    private String sale;

    /**
     * 代理人code，系统内媒介和销售角色的用户code
     */
    private String proxyCode;
}
