package com.bxm.adsmanager.model.dto;

import java.io.Serializable;
import java.math.BigDecimal;

import javax.validation.constraints.NotNull;

import com.bxm.adsmanager.model.base.BaseDto;

import lombok.Data;

@Data
public class DownloadLandingPageDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "ID不能为空", groups = { DownloadLandingPageDTO.Update.class })
    private Long id;

    @NotNull(message = "下载不能为空", groups = { DownloadLandingPageDTO.Add.class, DownloadLandingPageDTO.Update.class })
    private String downloadUrl;

    @NotNull(message = "应用名称不能为空", groups = { DownloadLandingPageDTO.Add.class, DownloadLandingPageDTO.Update.class })
    private String appName;

    @NotNull(message = "系统类型不能为空", groups = { DownloadLandingPageDTO.Add.class, DownloadLandingPageDTO.Update.class })
    private Byte osType;

    @NotNull(message = "下载安装包的IOS Id/包名不能为空", groups = { DownloadLandingPageDTO.Add.class, DownloadLandingPageDTO.Update.class })
    private String appPackageName;

    @NotNull(message = "应用介绍不能为空", groups = { DownloadLandingPageDTO.Add.class, DownloadLandingPageDTO.Update.class })
    private String appDesc;

    @NotNull(message = "应用大小不能为空", groups = { DownloadLandingPageDTO.Add.class, DownloadLandingPageDTO.Update.class })
    private BigDecimal appSize;

    @NotNull(message = "开发者名称不能为空", groups = { DownloadLandingPageDTO.Add.class, DownloadLandingPageDTO.Update.class })
    private String developerName;

    @NotNull(message = "版本号不能为空", groups = { DownloadLandingPageDTO.Add.class, DownloadLandingPageDTO.Update.class })
    private String version;

    @NotNull(message = "隐私协议不能为空", groups = { DownloadLandingPageDTO.Add.class, DownloadLandingPageDTO.Update.class })
    private String privacyAgreementUrl;

    @NotNull(message = "用户权限不能为空", groups = { DownloadLandingPageDTO.Add.class, DownloadLandingPageDTO.Update.class })
    private String userRightsUrl;

    private Integer trialTime;

    /**
     * 下载完成是否自动拉起：0否，1是
     */
    private Byte downloadDoneAutoPullUp;

    private String deeplinkUrl;

    @NotNull(message = "应用Icon不能为空", groups = { DownloadLandingPageDTO.Add.class, DownloadLandingPageDTO.Update.class })
    private String appIconUrl;

    public interface Add {  }

    public interface Update {   }
}
