package com.bxm.adsmanager.model.dto;

import com.bxm.adsmanager.model.base.BaseModel;
import org.apache.commons.lang3.StringUtils;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "开发者广告系统相关字段")
public class InfoPositionMsgDto extends BaseModel {
	
	private static final String FH = "-";

    /**
     * id
     */
    @ApiModelProperty(value = "id", required = true)
    private Long   id;

    /**
     * 媒介
     */
    @ApiModelProperty(value = "媒介")
    private String medium;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 别名
     */
    @ApiModelProperty(value = "别名")
    private String alias;
    
    private String positionId;
    
    private String aliasShow;
    
    //拼接子渠道名称，方便媒介查看
    public String getAliasShow() {
    	String id = StringUtils.isNotEmpty(positionId) && positionId.contains(FH) ? 
    			StringUtils.split(positionId, FH)[1] : "";
    	aliasShow = StringUtils.isNotEmpty(alias) ? alias : positionId;
    	return StringUtils.isNotEmpty(aliasShow) ? "("+id+")" + aliasShow : "UNKNOW";
	}

	public void setAliasShow(String aliasShow) {
		this.aliasShow = aliasShow;
	}

	public String getPositionId() {
		return positionId;
	}

	public void setPositionId(String positionId) {
		this.positionId = positionId;
	}

	/**
     * @return the id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * @return the medium
     */
    public String getMedium() {
        return medium;
    }

    /**
     * @param medium the medium to set
     */
    public void setMedium(String medium) {
        this.medium = medium;
    }

    /**
     * @return the remark
     */
    public String getRemark() {
        return remark;
    }

    /**
     * @param remark the remark to set
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    /**
     * @return the alias
     */
    public String getAlias() {
        return alias;
    }

    /**
     * @param alias the alias to set
     */
    public void setAlias(String alias) {
        this.alias = alias;
    }

}
