package com.bxm.adsmanager.model.dto;

import com.bxm.adsmanager.model.base.BaseDto;
import com.bxm.util.DateUtil;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;

/**
 * 文 件 名 :
 * CopyRright (c) 2008-xxxx:
 * 文件编号：
 * 创 建 人： hxpeng
 * 日 期： 2018/7/16 14:38
 * 修 改 人：
 * 日 期：
 * 描 述：落地页数据查询条件
 * 版 本 号： v1
 */
public class LandUserPageParamsDTO extends BaseDto implements Serializable {
    private static final long serialVersionUID = -7415412444071283367L;

    /**
     * 广告位
     */
    private String advertisingPosition;

    /**
     * 关键字查询条件， 关键字非数字时，模糊查询券表获取相关的券ID， 此条件由keywords查询条件获得
     */
    private Set<Long> ticketIds;

    /**
     * appKey集合
     */
    private Set<String> appKeys;

    /**
     * 广告位ID集合， （不含APP KEY, 前缀是ad-）
     */
    private Set<String> businessIds;

    private Set<String> positionIds;

    public String getAdvertisingPosition() {
        return advertisingPosition;
    }

    public void setAdvertisingPosition(String advertisingPosition) {
        if (StringUtils.isNotBlank(advertisingPosition)) {
            this.advertisingPosition = advertisingPosition.trim();
        }
    }

    public Set<Long> getTicketIds() {
        return ticketIds;
    }

    public void setTicketIds(Set<Long> ticketIds) {
        this.ticketIds = ticketIds;
    }

    public Set<String> getAppKeys() {
        return appKeys;
    }

    public void setAppKeys(Set<String> appKeys) {
        this.appKeys = appKeys;
    }

    public Set<String> getBusinessIds() {
        return businessIds;
    }

    public void setBusinessIds(Set<String> businessIds) {
        this.businessIds = businessIds;
    }

    @Override
    public void setEndTime(Date endTime) {
        endTime = endTime == null ? new Date() : DateUtil.increaseDate(endTime, -1);
        super.setEndTime(com.bxm.adsmanager.integration.utils.DateUtil.setEndTimeInOneDay(endTime));
    }

    @Override
    public void setStartTime(Date startTime) {
        if (null != startTime) {
            startTime = com.bxm.adsmanager.integration.utils.DateUtil.setBeginTimeInOneDay(startTime);
        }
        super.setStartTime(startTime);
    }

    public Set<String> getPositionIds() {
        return positionIds;
    }

    public void setPositionIds(Set<String> positionIds) {
        this.positionIds = positionIds;
    }
}
