package com.bxm.adsmanager.model.dto;

import com.bxm.adsmanager.model.vo.LandingPageConfigVo;
import lombok.Data;
import org.hibernate.validator.constraints.ISBN;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author tangx
 * @date 2021/3/12 10:14
 */
@Data
public class LandingPagePlanDto implements Serializable {

    private static final long serialVersionUID = 7778948030008946097L;

    private Long id;

    @NotNull(message = "ticketId不能为null")
    private Long ticketId;

    private List<LandingPageConfigVo> landingPageConfigVoList;

    private String landingPageConfigs;

    @NotBlank(message = "startTime不能为空")
    private String startTime;

    @NotBlank(message = "endTime不能为空")
    private String endTime;

    /**
     * 开始日期
     */
    private String startDate;

    /**
     * 结束日期
     */

    private String endDate;

}
