package com.bxm.adsmanager.model.dto;

import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;

/**
 * @author tangx
 * @date 2022/7/18 18:14
 */
@Data
public class OcpxRtbConfigDto {


    @NotNull
    private Long id;

    /**
     * rtb媒体代号 如: kuaishou
     */
    @NotBlank
    private String rtbMedia;

    /**
     * rtb广告主代号 如：taobao
     */
    @NotBlank
    private String rtbAdvertiser;

    /**
     * 上报需要的字段
     * 规则 [{"field": "advertiserSpaceId", "value": "7778888"}, {"field": "taskId", "value": "1234"}]
     */
    private String customUrlFields;

    /**
     * 回传策略 1.直接回传 2.概率回传
     */
    @NotNull
    private Integer strategyType;

    /**
     * 上报概率 0-100
     */
    private Double rate;

    /**
     * 1单目标  2 双目标
     */
    @NotNull
    private Integer targetType;

    /**
     * 回传浅层目标类型
     */
    @NotBlank
    private String targetOneRtb;

    /**
     * 回传深层目标类型
     */
    private String targetTwoRtb;

    /**
     * 对应的广告主行为类型
     */
    @NotBlank
    private String relateOneRtb;

    /**
     * 对应的广告主深层行为类型
     */
    private String relateTwoRtb;

    /**
     * 生成的链接
     */
    private String link;


    @Data
    public static class UrlField {
        private String field;
        private String value;
    }

}
