package com.bxm.adsmanager.model.dto;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

import javax.validation.constraints.NotNull;

import lombok.Data;

@Data
public class PanguCreativeBatchUpdateTagDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final int OPERA_TYPE_ADD = 1;
    public static final int OPERA_TYPE_REPLACE = 2;
    public static final int OPERA_TYPE_DELETE = 3;

    /**
     * 标签最大数量
     */
    public static final int TAG_MAX = 5;

    /**
     * ID
     */
    @NotNull(message = "ID不能为空", groups = { PanguCreativeBatchUpdateTagDTO.Update.class })
    private List<Long> ids;

    /**
     * 标签
     */
    @NotNull(message = "标签不能为空", groups = { PanguCreativeBatchUpdateTagDTO.Update.class })
    private List<String> tags;

    /**
     * 操作类型：1新增，2覆盖，3删除
     */
    @NotNull(message = "操作类型不能为空", groups = { PanguCreativeBatchUpdateTagDTO.Update.class })
    private int operaType;

    public interface Update {   }
}
