package com.bxm.adsmanager.model.dto;

import java.io.Serializable;
import java.util.List;

import javax.validation.constraints.NotNull;

import org.hibernate.validator.constraints.NotEmpty;
import org.springframework.validation.annotation.Validated;

import lombok.Data;

/**
 * 盘古素材库-素材数据对象<br/>
 *
 * @author zhengwangeng
 * @since 2021-12-7
 */
@Data
public class PanguCreativeDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 标签
     */
    private List<String> tags;

    /**
     * 素材对象
     */
    @NotEmpty(message = "素材对象不能为空")
    private List<Creative> creatives;

    @Data
    @Validated
    public static class Creative {

        /**
         * 图片
         */
        @NotNull(message = "图片不能为空")
        private String picture;

        /**
         * 尺寸
         */
        @NotNull(message = "尺寸不能为空")
        private String size;

        /**
         * 文件格式
         */
        @NotNull(message = "文件格式不能为空")
        private String format;

        /**
         * md5
         */
        @NotNull(message = "文件md5不能为空")
        private String md5;
    }
    
}
