package com.bxm.adsmanager.model.dto;

import java.io.Serializable;
import java.util.List;

import com.bxm.adsmanager.model.base.BaseDto;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 素材 列表查询对象<br/>
 *
 * @author zhengwangeng
 * @since 2021-12-7
 */
@Data
public class PanguCreativeSearchDTO extends BaseDto implements Serializable {

    private static final long serialVersionUID = 8255898196234336477L;

    /**
     * id列表
     */
    private List<Integer> ids;

    /**
     * 尺寸
     */
    private String size;

    /**
     * 格式
     */
    private String format;

    /**
     * 状态
     */
    private Short status;

    /**
     * MD5
     */
    private String md5;

    /**
     * 标签
     */
    private List<String> tags;

    /**
     * 是否有标签：false为没有标签
     */
    private Boolean hasTags;

    /**
     * 创建开始时间,例:2021-12-05
     */
    private String startCreateTime;

    /**
     * 创建结束时间,例:2021-12-06
     */
    private String endCreateTime;
    
}
