package com.bxm.adsmanager.model.dto;

import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @author tangx
 * @date 2020/5/12 17:06
 */
@Data
public class PrechargeCorrectDTO {


    @NotNull(message = "账户id不能为空")
    private Long accountId;

    /**
     * 修正金额
     */
    @NotNull
    private BigDecimal correctAmount;

    /**
     * 修正日期
     */
    private String datetime;

    /**
     * 修正类型 1.增加 2.减少
     */
    @NotNull(message = "修正类型不能为空")
    private Byte correctType;

    /**
     * 修正原因
     */
    @NotBlank
    private String correctReason;

    private String createUser;

}
