package com.bxm.adsmanager.model.dto;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

import javax.validation.constraints.NotNull;

import lombok.Data;

/**
 * 代理数据（下游）.</br>
 * Created by zhengwangeng on 2022/6/24.
 */
@Data
public class ProxyChannelDataBatchUpdateDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @NotNull(message = "ID不能为空", groups = { Update.class })
    private List<Long> ids;

    /**
     * 下游
     */
    private String ds;

    /**
     * 下游单价
     */
    private BigDecimal dsPrice;

    public interface Update {   }
}
