package com.bxm.adsmanager.model.dto;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import javax.validation.constraints.NotNull;

import org.springframework.format.annotation.DateTimeFormat;

import com.bxm.warcar.utils.localdate.LocalDateTimeHelper;
import com.fasterxml.jackson.annotation.JsonFormat;

import lombok.Data;

/**
 * 代理数据（下游）.</br>
 * Created by zhengwangeng on 2022/6/24.
 */
@Data
public class ProxyChannelDataDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @NotNull(message = "ID不能为空", groups = { Add.class, Update.class })
    private Long id;

    /**
     * ID列表
     */
    @NotNull(message = "ID不能为空", groups = { Empty.class })
    private List<Long> ids;

    /**
     * 日期
     */
    @NotNull(message = "日期不能为空", groups = { Add.class })
    @DateTimeFormat(pattern = LocalDateTimeHelper.PATTERN_STR10)
    private Date thedate;

    /**
     * 代理名称
     */
    @NotNull(message = "代理名称不能为空", groups = { Add.class })
    private String agencyName;

    /**
     * 渠道号
     */
    @NotNull(message = "渠道号不能为空", groups = { Add.class })
    private String channelNo;

    /**
     * 下游
     */
    @NotNull(message = "下游不能为空", groups = { Add.class, Update.class})
    private String ds;

    /**
     * 下游单价
     */
    @NotNull(message = "下游单价不能为空", groups = { Add.class })
    private BigDecimal dsPrice;

    /**
     * 下游CPS佣金
     */
    @NotNull(message = "下游CPS佣金不能为空", groups = { Add.class })
    private BigDecimal dsCpsBrokerage;

    /**
     * 下游收入
     */
    @NotNull(message = "下游收入不能为空", groups = { Add.class, Update.class })
    private BigDecimal dsIncome;

    /**
     * 下游有效点击数
     */
    private Long dsValidClick;


    /**
     * 代理人名称
     */
    @NotNull(message = "外放代理人不能为空", groups = { Update.class })
    private String proxyCode;

    public interface Add {  }

    public interface Update {  }

    public interface Empty {  }

}
