package com.bxm.adsmanager.model.dto;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;

import com.bxm.adsmanager.model.vo.ProxyChannelDataVO;

import cn.afterturn.easypoi.excel.annotation.Excel;
import lombok.Data;

/**
 * 代理数据（下游）.</br>
 * Created by zhengwangeng on 2022/6/24.
 */
@Data
public class ProxyChannelDataImportExcelDTO extends ProxyChannelDataVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 下游单价
     */
    @Excel(name = "下游有效点击单价")
    @Digits(integer = 10, fraction = 2, message = "下游有效点击单价整数位最多10位,小数位最多2位")
    @DecimalMin(value = "0", message = "下游有效点击单价不能为负数")
    private BigDecimal dsPrice;

    /**
     * 下游CPS佣金
     */
    @Excel(name = "下游CPS佣金")
    @Digits(integer = 10, fraction = 2, message = "下游CPS佣金整数位最多3位,小数位最多2位")
    @DecimalMin(value = "0", message = "下游CPS佣金不能为负数")
    private BigDecimal dsCpsBrokerage;

    /**
     * 下游收入
     */
    @Excel(name = "下游收益")
    @Digits(integer = 10, fraction = 2, message = "下游收益整数位最多10位,小数位最多2位")
    @DecimalMin(value = "0", message = "下游收益不能为负数")
    private BigDecimal dsIncome;
}
