package com.bxm.adsmanager.model.dto;

import java.io.Serializable;
import java.util.Set;

import org.apache.ibatis.annotations.Param;

import com.bxm.adsmanager.model.base.BaseDto;

import lombok.Data;

/**
 * 代理数据（下游）.</br>
 * Created by zhengwangeng on 2022/6/24.
 */
@Data
public class ProxyChannelDataSearchDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 日期
     */
    private String thedate;

    /**
     * 开始日期
     */
    private String startTime;

    /**
     * 结束日期
     */
    private String endTime;

    /**
     * 代理名称
     */
    private String agencyName;

    /**
     * 产品名称
     */
    private String productName;

    /**
     * 渠道号
     */
    private String channelNo;


    /**
     * 代理人code，系统内媒介和销售角色的用户code
     */
    private String proxyCode;

    /**
     * 下游
     */
    private String ds;

    /**
     * 下游收益是否为不为空：true=不为空，false=为空
     */
    private Boolean dsIncomeisNotNull;

    private Integer id;

    private Integer pageNum = 1;

    private Integer pageSize = 20;
}
