package com.bxm.adsmanager.model.dto.adarpu;

import com.bxm.adsmanager.model.base.BaseDto;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.Pattern;

/**
 * @ClassName AdDoMainArpuDto
 * @Description 礼券权重
 * @Author xw
 * @Date 2018/4/17 17:57
 * @Version 1.0
 * @Modifier xw
 * @Modify Date 2018/4/17 17:57
 **/
public class AdDoMainArpuDto extends BaseDto {
    /**
     * 所属行业名称
     */
    private String typeName;
    /**
     * 所属行业
     */
    @NotBlank(message = "广告分类不能为空",groups = {AdDoMainArpuDto.Add.class, AdDoMainArpuDto.Update.class})
    private String typeCode;
    /**
     * cpc 默认Arpu值
     */
    @Pattern(message = "cpcArpu格式不正确", regexp = "^\\d+(\\.\\d{1,2})?$" ,groups = {AdDoMainArpuDto.Add.class, AdDoMainArpuDto.Update.class})
    private String cpcArpu;
    /**
     * cpa 默认Arpu值
     */
    @Pattern(message = "cpaArpu格式不正确", regexp = "^\\d+(\\.\\d{1,2})?$" ,groups = {AdDoMainArpuDto.Add.class, AdDoMainArpuDto.Update.class})
    private String cpaArpu;
    /**
     * ocpc 默认Arpu值
     */
    @Pattern(message = "ocpcArpu格式不正确", regexp = "^\\d+(\\.\\d{1,2})?$" ,groups = {AdDoMainArpuDto.Add.class, AdDoMainArpuDto.Update.class})
    private String ocpcArpu;

    private String createUser;
    private String modifyUser;
    
    private Double defaultClickRate;//默认素材点击率

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getTypeCode() {
        return typeCode;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public String getCpcArpu() {
        return cpcArpu;
    }

    public void setCpcArpu(String cpcArpu) {
        this.cpcArpu = cpcArpu;
    }

    public String getCpaArpu() {
        return cpaArpu;
    }

    public void setCpaArpu(String cpaArpu) {
        this.cpaArpu = cpaArpu;
    }

    public String getOcpcArpu() {
        return ocpcArpu;
    }

    public void setOcpcArpu(String ocpcArpu) {
        this.ocpcArpu = ocpcArpu;
    }

    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public String getModifyUser() {
        return modifyUser;
    }

    public void setModifyUser(String modifyUser) {
        this.modifyUser = modifyUser;
    }
    

    public Double getDefaultClickRate() {
        return defaultClickRate;
    }

    public void setDefaultClickRate(Double defaultClickRate) {
        this.defaultClickRate = defaultClickRate;
    }

    
    @Override
    public String toString() {
        return "AdDoMainArpuDto [typeName=" + typeName + ", typeCode=" + typeCode + ", cpcArpu=" + cpcArpu
                + ", cpaArpu=" + cpaArpu + ", ocpcArpu=" + ocpcArpu + ", createUser=" + createUser + ", modifyUser="
                + modifyUser + ", defaultClickRate=" + defaultClickRate + "]";
    }



    public interface Add {
    }

    public interface Update {
    }
}
