/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */

package com.bxm.adsmanager.model.dto.adprofit;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.bxm.commons.currency.Money;

import java.math.BigDecimal;
import java.util.Date;

public class AdProfitPositionDto  implements java.io.Serializable {
    private static final long serialVersionUID = -7397328774676872181L;
    private static final long DEFULT_ZERO = 0L;
    @Excel(name = "ID", orderNum = "1")
    private Long id;

    @Excel(name = "日期", orderNum = "0")
    private String datetime;

    @Excel(name = "appId")
    private String appId;
    @Excel(name = "广告位id")
    private String positionId;

    private Double profitCheat;
    @Excel(name = "预估收益")
    private Double profitPredict;
    private Long profitPredictLi;
    @Excel(name = "扣量金额")
    private Double profitDeduct;
    private Long profitDeductLi;
    private Double profitActual;
    private Long profitActualLi;
    @Excel(name = "昨日实际uvarpu")
    private BigDecimal yesterPredictArpu;
    @Excel(name = "昨日预估uvarpu")
    private BigDecimal yesterActualArpu;
    @Excel(name = "备注")
    private String remark;

    private Short isImport;

    private Short isUpload;

    private String uploadMsg;

    private String createUser;

    private Date createTime;

    private String modifyUser;

    private Date modifyTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDatetime() {
        return datetime;
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime == null ? null : datetime.trim();
    }

    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId == null ? null : positionId.trim();
    }

    public Double getProfitCheat() {
        return profitCheat;
    }

    public void setProfitCheat(Double profitCheat) {
        this.profitCheat = profitCheat;
    }

    public Double getProfitPredict() {
        return profitPredict;
    }

    public void setProfitPredict(Double profitPredict) {
        this.profitPredict = profitPredict;
    }

    public Double getProfitDeduct() {
        return profitDeduct;
    }

    public void setProfitDeduct(Double profitDeduct) {
        this.profitDeduct = profitDeduct;
    }

    public Double getProfitActual() {
        return profitActual;
    }

    public void setProfitActual(Double profitActual) {
        this.profitActual = profitActual;
    }

    public BigDecimal getYesterPredictArpu() {
        return yesterPredictArpu;
    }

    public void setYesterPredictArpu(BigDecimal yesterPredictArpu) {
        this.yesterPredictArpu = yesterPredictArpu;
    }

    public BigDecimal getYesterActualArpu() {
        return yesterActualArpu;
    }

    public void setYesterActualArpu(BigDecimal yesterActualArpu) {
        this.yesterActualArpu = yesterActualArpu;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public Short getIsImport() {
        return isImport;
    }

    public void setIsImport(Short isImport) {
        this.isImport = isImport;
    }

    public Short getIsUpload() {
        return isUpload;
    }

    public void setIsUpload(Short isUpload) {
        this.isUpload = isUpload;
    }

    public String getUploadMsg() {
        return uploadMsg;
    }

    public void setUploadMsg(String uploadMsg) {
        this.uploadMsg = uploadMsg == null ? null : uploadMsg.trim();
    }

    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser == null ? null : createUser.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getModifyUser() {
        return modifyUser;
    }

    public void setModifyUser(String modifyUser) {
        this.modifyUser = modifyUser == null ? null : modifyUser.trim();
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public Long getProfitPredictLi() {
        if(null!=profitPredict){
            Money money = Money.ofYuan(profitPredict);
            return money.getLi();
        }
        return DEFULT_ZERO;
    }

    public void setProfitPredictLi(Long profitPredictLi) {
        this.profitPredictLi = profitPredictLi;
    }

    public Long getProfitDeductLi() {
        if(null!=profitDeduct){
            Money money = Money.ofYuan(profitDeduct);
            return money.getLi();
        }
        return DEFULT_ZERO;
    }

    public void setProfitDeductLi(Long profitDeductLi) {
        this.profitDeductLi = profitDeductLi;
    }

    public Long getProfitActualLi() {
        if(null!=profitActual){
            Money money = Money.ofYuan(profitActual);
            return money.getLi();
        }
        return DEFULT_ZERO;
    }

    public void setProfitActualLi(Long profitActualLi) {
        this.profitActualLi = profitActualLi;
    }
}