package com.bxm.adsmanager.model.dto.adprofit;

import com.bxm.adsmanager.model.base.BaseDto;
import com.bxm.commons.currency.Money;

import java.util.List;

/**
 * <p>开发者收益接口相关前端参数类</p>
 *
 * @Description:
 * @Author: JandMin
 * @Date: 2018/6/11
 */
public class DeveloperProfitDto extends BaseDto{
    /**
     * 开发者名称名称或appkey
     */
    private List<String> keywordList;
    /**
     * 开始日期
     */
    private String startDate;
    /**
     * 截至日期
     */
    private String endDate;
    /**
     * 结算日期
     */
    private String dateTime;
    /**
     * 帐户预付类型
     *
     */
    private Integer advanceType;
    /**
     * 未结算金额
     */
    private Double unSettledProfit;
    /**
     * 需要结算金额
     */
    private Double settledProfit;

    /**
     * 备注
     */
    private String remark;

    public Double getSettledProfit() {
        return settledProfit;
    }

    public void setSettledProfit(Double settledProfit) {
        this.settledProfit = settledProfit;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getDateTime() {
        return dateTime;
    }

    public void setDateTime(String dateTime) {
        this.dateTime = dateTime;
    }

    public Integer getAdvanceType() {
        return advanceType;
    }

    public void setAdvanceType(Integer advanceType) {
        this.advanceType = advanceType;
    }

    public Double getUnSettledProfit() {
        if(null == this.unSettledProfit){
            return null;
        }
        Long liMoney = Money.ofYuan(unSettledProfit).getLi();
        return liMoney.doubleValue();
    }

    public void setUnSettledProfit(Double unSettledProfit) {
        this.unSettledProfit = unSettledProfit;
    }

    public List<String> getKeywordList() {
        return keywordList;
    }

    public void setKeywordList(List<String> keywordList) {
        this.keywordList = keywordList;
    }

    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

}
