package com.bxm.adsmanager.model.dto.advertiser;

import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * Description 修改/新增 站内户权重DTO
 *
 * @author hxpeng
 * <p>
 * Date 2018/12/11 14:41
 */
@Data
public class UpdateStationUserWeightDTO implements Serializable {

    private static final long serialVersionUID = -5650619081277126962L;

    @NotNull(message = "站内户权重计划ID不能为空！", groups = {UpdateStationUserWeightDTO.Update.class})
    private Long id;

    /**
     * 广告主ID
     */
    @NotNull(message = "广告主ID不能为空！", groups = {UpdateStationUserWeightDTO.Add.class})
    private Long advertiserId;

    /**
     * 提权广告类型
     */
    @NotNull(message = "提权广告类型不能为空！", groups = {UpdateStationUserWeightDTO.Add.class})
    private Integer ticketTagCode;

    /**
     * 是否限制流量包？ 1Y 0N
     */
    @NotNull(message = "是否限制流量包！", groups = {UpdateStationUserWeightDTO.Add.class, UpdateStationUserWeightDTO.Update.class})
    private Boolean limitFlowPackageFlag;

    /**
     * 流量包ID,  以逗号分隔的流量包ID字符串
     */
    @NotNull(message = "流量包ID集合不能为空！", groups = {UpdateStationUserWeightDTO.Add.class, UpdateStationUserWeightDTO.Update.class})
    private String flowPackageIdsStr;

    /**
     * 权重系数
     */
    @NotNull(message = "权重系数不能为空！", groups = {UpdateStationUserWeightDTO.Add.class, UpdateStationUserWeightDTO.Update.class})
    @Min(value = 100, message = "权重系数最小值为100", groups = {UpdateStationUserWeightDTO.Add.class, UpdateStationUserWeightDTO.Update.class})
    @Max(value = 1000, message = "权重系数最大值为1000", groups = {UpdateStationUserWeightDTO.Add.class, UpdateStationUserWeightDTO.Update.class})
    private Double weightCoefficient;

    /**
     * 计划提权后券消耗额度
     */
    @NotNull(message = "提权限额不能为空！", groups = {UpdateStationUserWeightDTO.Add.class, UpdateStationUserWeightDTO.Update.class})
    @Min(value = 1, message = "提权限额最小值为1", groups = {UpdateStationUserWeightDTO.Add.class, UpdateStationUserWeightDTO.Update.class})
    @Max(value = 9999999, message = "提权限额最大值为9999999", groups = {UpdateStationUserWeightDTO.Add.class, UpdateStationUserWeightDTO.Update.class})
    private BigDecimal weightPlanConsume;

    /**
     * 修改人
     */
    private String operationUserName;


    public UpdateStationUserWeightDTO() {
        // 默认不限制流量包
        this.limitFlowPackageFlag = false;
    }

    public interface Add {
    }

    public interface Update {
    }

}
