package com.bxm.adsmanager.model.dto.bes;

import java.io.Serializable;

import lombok.Data;

/**
 * <p>
 * 百度响应对象base
 * </p>
 *
 * @author zhengwangeng
 * @since 2021/8/30 17:38
 */
@Data
public class BesBaseResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final int STATUS_OK = 0;

    private int status;// 返回状态码 0：成功1：部分成功2：全部失败
    private Errors[] errors;//错误信息数组

    @Data
    public static class Errors {
        private Integer index;//如果传入单个元素，则index为0；如果传入的是数组，则index为出错的数组下标，从0开始
        private Integer code;//错误码 具体见错误码部分
        private String message;//错误信息
        private String field;//错误字段 发 生 错 误 的 字 段 说明
    }

    public boolean success(){
        return STATUS_OK == status;
    }

    public String getDetailMessage(){
        StringBuffer stringBuffer = new StringBuffer();
        if (success() == false && errors != null && errors.length > 0){
            for (Errors error : errors) {
                stringBuffer.append(error.getMessage()).append("\r\n");
            }
        }
        return stringBuffer.toString();
    }
}
