package com.bxm.adsmanager.model.dto.bes.advertiser;

import java.io.Serializable;

import lombok.Data;

/**
 * <p>
 * 百度 广告主
 * </p>
 *
 * @author zhengwangeng
 * @since 2021/8/30 17:04
 */
@Data
public class BesAdvertiserDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    //属性名 类型 说明 是否必填 备注

    private Long advertiserId;// 广告主 id 是 此 id 为 dsp 系统的广告主 id，需唯一
    private String advertiserLiteName;// 广告主名称 是 不超过 200 个字节。需唯一
    private String advertiserName;// 广告主主体资质名称 是 最少 3 个字节，不超过 200 个字节。可重复。 请确保此名称与客户营业执照上的名称一致，否则该客户创意无法正常投放。
    private String siteName;// 网站名 是 最长 100 个字符。
    private String siteUrl;// 网站 URL 是 最长 512 个字节，必须以 http:// 开头。
    private String telephone;// 联系电话 否 最长 100 个字符
    private String address;// 通讯地址 否 最长 100 个字符
    private Integer isWhiteUser;// 广告主是否白名单 否 0：非白名单；1：白名单 此字段在请求时不需要填写且不生效。只在返回时标识广告主是否白名单。

}
