package com.bxm.adsmanager.model.dto.bes.qualification;

import java.io.Serializable;
import java.util.List;

import com.bxm.adsmanager.model.dto.bes.BesBaseResponse;

import lombok.Data;

/**
 * <p>
 * 百度 查询广告主资质
 * </p>
 *
 * @author zhengwangeng
 * @since 2021/8/30 17:04
 */
@Data
public class BesQualificationResultDTO extends BesBaseResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    private APIAdvertiserQualificationInfo qualification;//资质列表 是 每个广告主对应1 个，不超过 5 个广告主

    @Data
    public static class APIAdvertiserQualificationInfo implements Serializable {

        private static final long serialVersionUID = 1L;

        private Long advertiserId;// 广 告 主id是 此 id 为 dsp 系统的广告主 id
        private String nickname;//  广告主资质名称
        private String website;// 广告主网址是
        private Integer auditState;// 资 质 审 核 状 态是0：审核通过；1：审核中；2：审核拒绝；3：缺省状态）

        private APIAdvertiserLicenceInfo mainLicence;// 主体资质 是
        private List<APIAdvertiserLicenceInfo> optionalLicences;//可选资质列表否

    }

    @Data
    public static class APIAdvertiserLicenceInfo implements Serializable {

        private static final long serialVersionUID = 1L;

        private Integer licenceStatus;//资质审核状态 是 2：通过；4：拒绝；6：待审
        private Integer type;//资质类型或行业类型 是 如果是主体资质，则填写资质类型，具体见资质类型字典；如果是可选资质，则填写资质行业类型，具体见资质行业类型字典；
        private String name;//名称（企业名称、主体名称、公司名称）是
        private String number;//编号（企业注册号、资质编号、登记号码、办学许可证号码）是
        private String validDate;//有效期 是
        private List<String> imgUrls;//  百度转储后的资质图片url 否 请求字段needLicenceImgUrl为true时提供
    }
}
