package com.bxm.adsmanager.model.dto.bes.qualification;

import java.io.Serializable;
import java.util.List;

import com.bxm.adsmanager.model.dto.bes.BesBaseResponse;

import lombok.Data;

/**
 * <p>
 * 百度 广告主资质状态
 * </p>
 *
 * @author zhengwangeng
 * @since 2021/8/30 17:04
 */
@Data
public class BesQualificationStatusesResultDTO extends BesBaseResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    private List<APIAdvertiserQualificationStatus> qualificationStatuses;//广 告 主 资质 提 交 状态

    @Data
    public static class APIAdvertiserQualificationStatus implements Serializable {

        private static final long serialVersionUID = 1L;

        private Long advertiserId;// 广 告 主id是 此 id 为 dsp 系统的广告主 id
        private Integer status;// 资质上传状态是0：提交失败；1：已提交；2：免提交
        private String message;//提交失败 message否提交失败信息

    }

}
