package com.bxm.adsmanager.model.dto.bes.qualification;

import java.io.Serializable;
import java.util.List;

import com.bxm.adsmanager.model.dto.bes.BesBaseRequest;

import lombok.Data;

/**
 * <p>
 * 百度 广告主资质上传
 * </p>
 *
 * @author zhengwangeng
 * @since 2021/8/30 17:04
 */
@Data
public class BesUploadQualificationDTO extends BesBaseRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    private List<APIAdvertiserQualificationUpload> qualifications;//资质列表 是 每个广告主对应1 个，不超过 5 个广告主

    @Data
    public static class APIAdvertiserQualificationUpload implements Serializable {

        private static final long serialVersionUID = 1L;

        private Long advertiserId;// 广 告 主id是 此 id 为 dsp 系统的广告主 id
        private APIAdvertiserLicence mainLicence;// 主体资质 是 必须提供一条主体资质
        private List<APIAdvertiserLicence> optionalLicences;//可选资质列表否 可选资质最多不超过 10 个

    }

    @Data
    public static class APIAdvertiserLicence implements Serializable {

        private static final long serialVersionUID = 1L;

        //2-大陆企业单位类客户
        private Integer type;//资质类型或行业类型 是 如果是主体资质，则填写资质类型，具体见资质类型字典；
        // 如果是可选资质，则填写资质行业类型，具体见资质行业类型字典；
        private String name;//  资质名称（企业名称、主体名称、公司名称）是 非空字符串，长度不超过 100
        private String number;// 资质编号（企业注册号、资质编号、登记号码、办学许可证号码）是 非空字符串，长度不超过 100
        private String validDate;// 有效期 是 非空字符串，长度不超过 100
        private List<byte[]> imgDatas;// 资质图片二进制数据列表 否 图片不超过 3 个，单个图片大小 不 超 过 2M ； 当 不 存 在imgUrls 时 ， 则 选 择 使
        // 用imgDatas 来上传，二者必须存在其一。imgDatas 的处理优先级高于 imgUrls。
        private List<String> imgUrls;//  资质图片 URL 列表 否 图片不超过 3 个，每个 url 长度限制 2048 个字节，每个图片大小不超过 2M；注：API 会在后台访问创意的URL
        // 地址，抓取图片或者 flash创意。请确保 URL 可连通并且可以通过 HTTP 协议在万维网上访 问到。
    }
}
