package com.bxm.adsmanager.model.dto.mediamanager;

import com.bxm.adsmanager.model.base.BaseDto;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;


/**
 * 广告位appId黑名单
 */
@Data
public class MediaPositionBlackAppIdDto extends BaseDto {

    @NotNull(groups = Update.class)
    private Integer id;

    @NotBlank(groups = Add.class)
    private String positionIds;

    private String positionId;

    @NotBlank(groups = Add.class)
    private String appIds;

    @NotBlank(groups = {Update.class, Add.class})
    private String reason;


    public interface Update {

    }

    public interface Add{

    }

}
