package com.bxm.adsmanager.model.dto.mediamanager;

import com.bxm.adsmanager.model.base.BaseDto;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketPersonsGradeConf;
import com.bxm.util.StringUtil;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import org.hibernate.validator.constraints.NotBlank;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * <h3>媒体测试</h3>
 * @author 拉拉
 * @since V1.0.0, 2018/04/08 18:55
 */
public class MediaTestDto extends BaseDto {

	@NotBlank(message = "媒体入口不能为空", groups = {MediaTestDto.Add.class,MediaTestDto.Update.class})
	private String positionId;//媒体入口
	@NotBlank(message = "礼券id不能为空", groups = {MediaTestDto.Add.class,MediaTestDto.Update.class})
	private String ticketId;//礼券id,多个以，分隔
	@NotBlank(message = "媒体测试名称不能为空", groups = {MediaTestDto.Add.class,MediaTestDto.Update.class})
	private String testName;//媒体测试名称
	@NotNull(message = "测试数量不能为空", groups = {MediaTestDto.Add.class,MediaTestDto.Update.class})
	private Integer count;//测试数量

	private Short state;//状态0- 未开启、1- 已开启（测试中，数据生成还需要判断开始时间）、2- 已完成
	
	private String mediaStartTime;//开始时间
 
 
    public String getPositionId() {
        return positionId;
    }
    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public String getTicketId() {
        return ticketId;
    }
    public void setTicketId(String ticketId) {
        this.ticketId = ticketId;
    }

    public String getTestName() {
        return testName;
    }
    public void setTestName(String testName) {
        this.testName = testName;
    }
    
    public Integer getCount() {
        return count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }
    

    public Short getState() {
        return state;
    }

    public void setState(Short state) {
        this.state = state;
    }
 
    
    /**
     * @return the mediaStartTime
     */
    public String getMediaStartTime() {
        return mediaStartTime;
    }
    
    /**
     * @param mediaStartTime the mediaStartTime to set
     */
    public void setMediaStartTime(String mediaStartTime) {
        this.mediaStartTime = mediaStartTime;
    }

    public interface Add{}
	public interface Update{}
}
