package com.bxm.adsmanager.model.dto.menu;

import com.bxm.adsmanager.model.vo.AdMenuVo;
import org.apache.commons.collections.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @ClassName AdMenuDto
 * @Description 封装菜单信息返回前端
 * @Author xw
 * @Date 2018/4/11 16:42
 * @Version 1.0
 * @Modifier xw
 * @Modify Date 2018/4/11 16:42
 **/
public class AdMenuDto {
    private String path;//菜单路径

    private String name;//名称编码

    private String hidden;//隐藏

    private List<AdMenuDto> children;//子菜单

    private Map<String,Object> meta;//菜单基础

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHidden() {
        return hidden;
    }

    public void setHidden(String hidden) {
        this.hidden = hidden;
    }

    public List<AdMenuDto> getChildren() {
        return children;
    }

    public void setChildren(List<AdMenuDto> children) {
        this.children = children;
    }

    public Map<String, Object> getMeta() {
        return meta;
    }

    public void setMeta(Map<String, Object> meta) {
        this.meta = meta;
    }

    public AdMenuDto() {

    }

    public AdMenuDto(AdMenuVo vo) {
        this.path = vo.getPath();
        this.name = vo.getName();
        this.hidden = vo.getHidden();
        this.children = new ArrayList<AdMenuDto>();
        this.meta = new HashMap<String,Object>();
        this.meta.put("title",vo.getTitle());

        List<AdMenuVo> adMenuVos = vo.getChildren();
        if(CollectionUtils.isNotEmpty(adMenuVos)){
            for(AdMenuVo menu : adMenuVos){
                this.children.add(new AdMenuDto(menu));
            }
        }
    }
}
