package com.bxm.adsmanager.model.dto.mobile;

import com.bxm.adsmanager.integration.utils.DateUtil;
import com.bxm.adsmanager.model.base.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 文 件 名 :
 * CopyRright (c) 2008-xxxx:
 * 文件编号：
 * 创 建 人： hxpeng
 * 日 期： 2018/7/31 15:00
 * 修 改 人：
 * 日 期：
 * 描 述： 移动端 广告券列表查询条件DTO
 * 版 本 号： v1
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class TicketQueryConditionDTO extends BaseDto implements Serializable {

    private static final long serialVersionUID = -3092671586238777542L;
    /**
     * 广告券是否启用， 1启用， 0关闭， 默认查询启用页
     */
    private Integer ticketStatusFlag;

    /**
     * 广告主ID集合 --> by keywords
     */
    private List<Integer> advertiserIds;

    /**
     * 广告券状态查询条件 -- > by ticketStatusFlag
     */
    private Integer[] status;

    private String ae;

    /**
     * 移动端 的pv查询时间段， 为当天， 这里重写
     */
    public TicketQueryConditionDTO() {
        this.ticketStatusFlag = 1;

        Date date = new Date();
        super.setStartTime(DateUtil.setBeginTimeInOneDay(date));
        // 基类中 setEndTime 默认会加一天，这里减少一天
        super.setEndTime(DateUtil.setEndTimeInOneDay(com.bxm.util.DateUtil.increaseDate(date, -1)));

        super.setPageNum(1);
        super.setPageStart(20);
    }

}
