package com.bxm.adsmanager.model.dto.mobile;

import lombok.Data;

import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 文 件 名 :
 * CopyRright (c) 2008-xxxx:
 * 文件编号：
 * 创 建 人： hxpeng
 * 日 期： 2018/8/1 18:49
 * 修 改 人：
 * 日 期：
 * 描 述：
 * 版 本 号： v1
 */
@Data
public class TicketUpdateDTO implements Serializable {

    private static final long serialVersionUID = 534787661412745971L;

    /**
     * 券ID
     */
    @NotNull(message = "广告券ID不能为空")
    private Long id;

    /**
     * 单价, 日预算
     */
    @NotNull(message = "单价不能为空")
    @DecimalMin(value = "0.001", message = "出价必须大于0.001")
    private BigDecimal price;
    @NotNull(message = "日预算不能为空")
    @DecimalMin(value = "0.001", message = "日预算必须大于0.001")
    private BigDecimal budgetDaily;

    /**
     * 预期CPA, 广告位屏蔽阀值
     */
    private BigDecimal cpaExpectPrice;
    private Integer closeThreshold;

    /**
     * 新增字段oldPrice
     */
    private BigDecimal oldPrice;

    /**
     * 流量包限价及预算
     */
    private String flowPackageArray;

}
