package com.bxm.adsmanager.model.dto.mobile;

import com.bxm.util.UuidUtil;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 文 件 名 :
 * CopyRright (c) 2008-xxxx:
 * 文件编号：
 * 创 建 人： hxpeng
 * 日 期： 2018/8/2 10:09
 * 修 改 人：
 * 日 期：
 * 描 述： 移动端 登陆用户会话 容器
 * 版 本 号： v1
 */
@NoArgsConstructor
@Data
public class UserSessionDTO implements Serializable {

    private static final long serialVersionUID = -8724758465420274634L;

    /**
     * 会话ID, 用户名称, 权限CODE, 真实名称
     */
    private String sessionId;
    private String userName;
    private String[] roleCodes;
    private String realName;


    public UserSessionDTO(String userName) {
        this.sessionId = UuidUtil.getUuidByJdk(true);
        this.roleCodes = new String[]{"AE"};
        this.userName = userName;
        this.realName = userName;
    }
}
