package com.bxm.adsmanager.model.dto.monitor;
import com.bxm.adsmanager.model.dao.user.User;

import java.io.Serializable;
import java.util.List;

/**
* @Title:PositionSpareTicketDto.java
* @Package:com.bxm.adsmanager.model.dto.monitor
* @Description: 广告位备用券查询实体类
* @date:2018年10月8日 下午2:17:57
* @author wangchao
 */
public class PositionSpareTicketDto implements Serializable{
    
    
    private static final long serialVersionUID = 4449177125531775195L;
    
    /**
     * 广告位名称或者id
     */
    private String keywords;
    
    /**
     * 媒介code
     */
    private String mediumCode;
    
    /**
     * 广告位ID
     */
    private String positionId;
    
    /**
     * 查询的广告位的集合
     */
    private List<String> positionIds;
    
    /**
     * 排除查询的广告位的集合
     */
    private List<String> excludePositionIds;
    
    /**
     * 发券量
     */
    private Double openPv;
    
    /**
     * 备用券发券占比(最大)
     */
    private Double spareOpenProportionMax;
    
    /**
     * 备用券发券占比(最小)
     */
    private Double spareOpenProportionMin;
    
    /**
     * 页面号
     */
    private Integer pageNum = 1;
    
    /**
     * 页面大小
     */
    private Integer pageSize = 20;
    
    /**
     * 开始查询时间
     */
    private String startTime;
    
    /**
     * 结束查询时间
     */
    private String endTime;
    
    /**
     * 监控时间段,近多少小时
     */
    private Integer monitorPeriod;
    
    private User user;

    public String getMediumCode() {
        return mediumCode;
    }

    public void setMediumCode(String mediumCode) {
        this.mediumCode = mediumCode;
    }

    public Double getOpenPv() {
        return openPv;
    }

    public void setOpenPv(Double openPv) {
        this.openPv = openPv;
    }

    public Double getSpareOpenProportionMax() {
        return spareOpenProportionMax;
    }

    public void setSpareOpenProportionMax(Double spareOpenProportionMax) {
        this.spareOpenProportionMax = spareOpenProportionMax;
    }

    public Double getSpareOpenProportionMin() {
        return spareOpenProportionMin;
    }
    
    public void setSpareOpenProportionMin(Double spareOpenProportionMin) {
        this.spareOpenProportionMin = spareOpenProportionMin;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getKeywords() {
        return keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public List<String> getPositionIds() {
        return positionIds;
    }

    public void setPositionIds(List<String> positionIds) {
        this.positionIds = positionIds;
    }

    public List<String> getExcludePositionIds() {
        return excludePositionIds;
    }

    public void setExcludePositionIds(List<String> excludePositionIds) {
        this.excludePositionIds = excludePositionIds;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public Integer getMonitorPeriod() {
        return monitorPeriod;
    }

    public void setMonitorPeriod(Integer monitorPeriod) {
        this.monitorPeriod = monitorPeriod;
    }

    public User getUser() {
        return user;
    }

    public void setUser(User user) {
        this.user = user;
    }
}
